/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.Table;
import gnu.trove.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class DefineMacrosDialog
extends DialogWrapper {
    public static final int MACRO_NAME = 0;
    public static final int MACRO_VALUE = 1;
    private final String[][] myMacroTable;
    private final TObjectIntHashMap myIndex = new TObjectIntHashMap();

    public DefineMacrosDialog(String[] macroNames) {
        super(true);
        this.myMacroTable = new String[macroNames.length][2];
        for (int idx = 0; idx < macroNames.length; ++idx) {
            String macroName = macroNames[idx];
            this.myMacroTable[idx] = new String[]{macroName, ""};
            this.myIndex.put((Object)macroName, idx);
        }
        this.setCancelButtonText(ProjectBundle.message((String)"project.macros.cancel.button", (Object[])new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        for (int idx = 0; idx < this.myMacroTable.length; ++idx) {
            String[] row = this.myMacroTable[idx];
            String path = row[1];
            if (path == null || path.length() == 0) {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)ProjectBundle.message((String)"project.macros.variable.missing.error", (Object[])new Object[]{row[0]}), (String)ProjectBundle.message((String)"project.macros.variable.missing.title", (Object[])new Object[0]));
                return;
            }
            if (new File(path).exists()) continue;
            Messages.showErrorDialog((Component)this.getContentPane(), (String)ProjectBundle.message((String)"project.macros.variable.missing.error", (Object[])new Object[]{row[0]}), (String)ProjectBundle.message((String)"project.macros.variable.missing.title", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        Table table = new Table((TableModel)new MyTableModel());
        JLabel label = new JLabel(ProjectBundle.message((String)"project.macros.prompt", (Object[])new Object[0]));
        label.setBorder(IdeBorderFactory.createEmptyBorder((int)6, (int)6, (int)6, (int)6));
        panel.add((Component)label, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)table), "Center");
        return panel;
    }

    public String getMacroValue(String macro) {
        int index = this.myIndex.get((Object)macro);
        return index >= 0 && index < this.myMacroTable.length ? this.myMacroTable[index][1] : null;
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ProjectBundle.message((String)"project.macros.name.column", (Object[])new Object[0]);
                }
                case 1: {
                    return ProjectBundle.message((String)"project.macros.path.column", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return DefineMacrosDialog.this.myMacroTable[0].length;
        }

        @Override
        public int getRowCount() {
            return DefineMacrosDialog.this.myMacroTable.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return DefineMacrosDialog.this.myMacroTable[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && aValue instanceof String) {
                ((DefineMacrosDialog)DefineMacrosDialog.this).myMacroTable[rowIndex][1] = (String)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

