/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbPermissionService;
import com.intellij.openapi.project.DumbPermissionServiceImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private static final NotNullLazyValue<DumbPermissionServiceImpl> ourPermissionService = new NotNullLazyValue<DumbPermissionServiceImpl>(){

        @NotNull
        protected DumbPermissionServiceImpl compute() {
            return (DumbPermissionServiceImpl)ServiceManager.getService(DumbPermissionService.class);
        }
    };
    private static Throwable ourForcedTrace;
    private volatile boolean myDumb = false;
    private volatile Throwable myDumbStart;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Queue<DumbModeTask> myUpdatesQueue = new Queue(5);
    private final Map<DumbModeTask, ProgressIndicatorEx> myProgresses = ContainerUtil.newConcurrentMap();
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private final ThreadLocal<Integer> myAlternativeResolution = new ThreadLocal();

    public DumbServiceImpl(Project project2) {
        this.myProject = project2;
        this.myPublisher = (DumbService.DumbModeListener)project2.getMessageBus().syncPublisher(DUMB_MODE);
    }

    public static DumbServiceImpl getInstance(@NotNull Project project2) {
        return (DumbServiceImpl)DumbService.getInstance((Project)project2);
    }

    public void queueTask(@NotNull DumbModeTask task) {
        this.scheduleCacheUpdate(task, true);
    }

    public void cancelTask(@NotNull DumbModeTask task) {
        ProgressIndicatorEx indicator;
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task);
        }
        if ((indicator = this.myProgresses.get(task)) != null) {
            indicator.cancel();
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdatesQueue.clear();
        this.myRunWhenSmartQueue.clear();
        for (DumbModeTask task : new ArrayList<DumbModeTask>(this.myProgresses.keySet())) {
            this.cancelTask(task);
            Disposer.dispose((Disposable)task);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolution.get() != null;
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        Integer oldValue = this.myAlternativeResolution.get();
        int newValue = (oldValue == null ? 0 : oldValue) + (enabled ? 1 : -1);
        assert (newValue >= 0) : "Non-paired alternative resolution mode";
        this.myAlternativeResolution.set(newValue == 0 ? null : Integer.valueOf(newValue));
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    public boolean isDumb() {
        return this.myDumb;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myDumb = true;
            this.myPublisher.enteredDumbMode();
        } else {
            this.updateFinished(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenSmart(@NotNull Runnable runnable2) {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            if (this.isDumb()) {
                this.myRunWhenSmartQueue.addLast((Object)runnable2);
                return;
            }
        }
        runnable2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCacheUpdate(final @NotNull DumbModeTask task, boolean forceDumbMode) {
        Application application;
        final Throwable trace = ourForcedTrace != null ? ourForcedTrace : new Throwable();
        final DumbModePermission schedulerPermission = DumbServiceImpl.getExplicitPermission();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task, trace);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment() || !forceDumbMode && !this.myDumb && application.isReadAccessAllowed()) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.pushState();
            }
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task");
            try {
                task.performInDumbMode((ProgressIndicator)(indicator != null ? indicator : new EmptyProgressIndicator()));
            }
            finally {
                token.finish();
                if (indicator != null) {
                    indicator.popState();
                }
                Disposer.dispose((Disposable)task);
            }
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                final DumbModePermission permission = schedulerPermission != null ? schedulerPermission : DumbServiceImpl.this.getEdtPermission();
                DumbServiceImpl.this.myProgresses.put(task, new ProgressIndicatorBase());
                Disposer.register((Disposable)task, (Disposable)new Disposable(){

                    public void dispose() {
                        application.assertIsDispatchThread();
                        DumbServiceImpl.this.myProgresses.remove(task);
                    }
                });
                DumbServiceImpl.this.myUpdatesQueue.addLast((Object)task);
                if (!DumbServiceImpl.this.myDumb) {
                    if (permission == null) {
                        LOG.info("Dumb mode not permitted in modal environment; see DumbService.allowStartingDumbModeInside documentation", trace);
                    } else if (permission == DumbModePermission.MAY_START_MODAL) {
                        LOG.info("Starting modal dumb mode, caused by the following trace", trace);
                    }
                    application.runWriteAction(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Queue queue = DumbServiceImpl.this.myRunWhenSmartQueue;
                            synchronized (queue) {
                                DumbServiceImpl.this.myDumb = true;
                            }
                            DumbServiceImpl.this.myDumbStart = trace;
                            DumbServiceImpl.this.myModificationCount++;
                            try {
                                DumbServiceImpl.this.myPublisher.enteredDumbMode();
                            }
                            catch (Throwable e) {
                                LOG.error(e);
                            }
                        }
                    });
                    application.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean modal = permission != DumbModePermission.MAY_START_BACKGROUND;
                            try {
                                DumbServiceImpl.this.startBackgroundProcess(modal);
                            }
                            catch (Throwable e) {
                                DumbServiceImpl.this.updateFinished(modal);
                                LOG.error("Failed to start background index update task", e);
                            }
                        }
                    }, ModalityState.any(), DumbServiceImpl.this.myProject.getDisposed());
                }
            }
        });
    }

    @Nullable
    private DumbModePermission getEdtPermission() {
        DumbModePermission permission = DumbServiceImpl.getExplicitPermission();
        if (permission != null) {
            return permission;
        }
        if (ModalityState.current() == ModalityState.NON_MODAL || !StartupManagerEx.getInstanceEx(this.myProject).postStartupActivityPassed()) {
            return DumbModePermission.MAY_START_BACKGROUND;
        }
        return null;
    }

    @Nullable
    public static DumbModePermission getExplicitPermission() {
        return ((DumbPermissionServiceImpl)ourPermissionService.getValue()).getPermission();
    }

    @NotNull
    public static AccessToken forceDumbModeStartTrace(@NotNull Throwable trace) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Throwable prev = ourForcedTrace;
        ourForcedTrace = trace;
        return new AccessToken(){

            public void finish() {
                ourForcedTrace = prev;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished(boolean modal) {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            this.myDumb = false;
        }
        this.myDumbStart = null;
        ++this.myModificationCount;
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        DumbServiceImpl.allowStartingDumbModeInside((DumbModePermission)(modal ? DumbModePermission.MAY_START_MODAL : DumbModePermission.MAY_START_BACKGROUND), (Runnable)new Runnable(){

            @Override
            public void run() {
                DumbServiceImpl.this.notifyUpdateFinished();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpdateFinished() {
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        catch (Throwable throwable) {
            while (!this.myDumb) {
                Runnable runnable2;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable2 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                try {
                    runnable2.run();
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce.trace", ExceptionUtil.getThrowableText((Throwable)e))});
                }
                catch (Throwable e) {
                    LOG.error("Error executing task " + runnable2, e);
                }
            }
            throw throwable;
        }
        while (!this.myDumb) {
            Runnable runnable3;
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                if (this.myRunWhenSmartQueue.isEmpty()) {
                    break;
                }
                runnable3 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
            }
            try {
                runnable3.run();
            }
            catch (ProcessCanceledException e) {
                LOG.error("Task canceled: " + runnable3, new Attachment[]{new Attachment("pce.trace", ExceptionUtil.getThrowableText((Throwable)e))});
            }
            catch (Throwable e) {
                LOG.error("Error executing task " + runnable3, e);
            }
        }
    }

    public void showDumbModeNotification(final @NotNull String message) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(DumbServiceImpl.this.myProject);
                if (ideFrame != null) {
                    StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                    statusBar.notifyProgressByBalloon(MessageType.WARNING, message, null, null);
                }
            }
        });
    }

    public void waitForSmartMode() {
        if (!this.isDumb()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.runWhenSmart(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        while (!semaphore.waitFor(50L)) {
            ProgressManager.checkCanceled();
        }
        return;
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    public void smartInvokeLater(final @NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbServiceImpl.this.runWhenSmart(runnable2);
            }

            public String toString() {
                return runnable2.toString();
            }
        }, this.myProject.getDisposed());
    }

    public void smartInvokeLater(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbServiceImpl.this.runWhenSmart(runnable2);
            }
        }, modalityState, this.myProject.getDisposed());
    }

    private void startBackgroundProcess(final boolean modal) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator visibleIndicator) {
                ShutDownTracker shutdownTracker = ShutDownTracker.getInstance();
                Thread self = Thread.currentThread();
                AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks");
                try {
                    Pair pair;
                    shutdownTracker.registerStopperThread(self);
                    if (visibleIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)visibleIndicator).addStateDelegate(new AppIconProgress());
                    }
                    DumbModeTask task = null;
                    while ((pair = DumbServiceImpl.this.getNextTask(task, modal)) != null) {
                        task = (DumbModeTask)pair.first;
                        ProgressIndicatorEx taskIndicator = (ProgressIndicatorEx)pair.second;
                        if (visibleIndicator instanceof ProgressIndicatorEx) {
                            taskIndicator.addStateDelegate(new AbstractProgressIndicatorExBase(){

                                @Override
                                protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action) {
                                    super.delegateProgressChange(action);
                                    action.execute((ProgressIndicatorEx)visibleIndicator);
                                }
                            });
                        }
                        DumbServiceImpl.runSingleTask(task, taskIndicator);
                    }
                }
                catch (Throwable unexpected) {
                    LOG.error(unexpected);
                }
                finally {
                    shutdownTracker.unregisterStopperThread(self);
                    token.finish();
                }
            }

            public boolean isConditionalModal() {
                return modal;
            }

            public boolean shouldStartInBackground() {
                return !modal;
            }
        });
    }

    private static void runSingleTask(final DumbModeTask task, final ProgressIndicatorEx taskIndicator) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task);
        }
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                try {
                    taskIndicator.checkCanceled();
                    taskIndicator.setIndeterminate(true);
                    taskIndicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                    task.performInDumbMode((ProgressIndicator)taskIndicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable unexpected) {
                    LOG.error(unexpected);
                }
            }
        }, (ProgressIndicator)taskIndicator);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> getNextTask(final @Nullable DumbModeTask prevTask, final boolean modal) {
        final Ref result = Ref.create();
        DumbServiceImpl.invokeAndWaitIfNeeded(new Runnable(){

            @Override
            public void run() {
                ProgressIndicatorEx indicator;
                DumbModeTask queuedTask;
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (prevTask != null) {
                    Disposer.dispose((Disposable)prevTask);
                }
                while (true) {
                    if (DumbServiceImpl.this.myUpdatesQueue.isEmpty()) {
                        DumbServiceImpl.this.updateFinished(modal);
                        return;
                    }
                    queuedTask = (DumbModeTask)DumbServiceImpl.this.myUpdatesQueue.pullFirst();
                    indicator = (ProgressIndicatorEx)DumbServiceImpl.this.myProgresses.get(queuedTask);
                    if (!indicator.isCanceled()) break;
                    Disposer.dispose((Disposable)queuedTask);
                }
                result.set((Object)Pair.create((Object)queuedTask, (Object)indicator));
            }
        });
        return (Pair)result.get();
    }

    private static void invokeAndWaitIfNeeded(Runnable runnable2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable2);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private class AppIconProgress
    extends ProgressIndicatorBase {
        private double lastFraction;

        private AppIconProgress() {
        }

        @Override
        public void setFraction(final double fraction) {
            if (fraction - this.lastFraction < 0.01) {
                return;
            }
            this.lastFraction = fraction;
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppIcon.getInstance().setProgress(DumbServiceImpl.this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true);
                }
            });
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (this.lastFraction != 0.0) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AppIcon appIcon = AppIcon.getInstance();
                        if (appIcon.hideProgress(DumbServiceImpl.this.myProject, "indexUpdate")) {
                            appIcon.requestAttention(DumbServiceImpl.this.myProject, false);
                            appIcon.setOkBadge(DumbServiceImpl.this.myProject, true);
                        }
                    }
                });
            }
        }
    }
}

