/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWrapper
extends AbstractProgressIndicatorBase
implements WrappedProgressIndicator,
StandardProgressIndicator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWrapper");
    private final ProgressIndicator myOriginal;
    private final boolean myCheckCanceledForMe;
    private final int nested;

    protected ProgressWrapper(@NotNull ProgressIndicator original) {
        this(original, false);
    }

    protected ProgressWrapper(@NotNull ProgressIndicator original, boolean checkCanceledForMe) {
        this.myOriginal = original;
        this.myCheckCanceledForMe = checkCanceledForMe;
        this.nested = 1 + (original instanceof ProgressWrapper ? ((ProgressWrapper)original).nested : -1);
        if (this.nested > 50) {
            LOG.error("Too many wrapped indicators");
        }
        ProgressManager.assertNotCircular((ProgressIndicator)original);
    }

    @Override
    public final void cancel() {
        super.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return this.myOriginal.isCanceled() || this.myCheckCanceledForMe && super.isCanceled();
    }

    @Override
    public final void checkCanceled() {
        this.myOriginal.checkCanceled();
        super.checkCanceled();
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        return this.myOriginal;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressWrapper wrap(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof ProgressWrapper ? (ProgressWrapper)indicator : new ProgressWrapper(indicator);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressIndicator unwrap(ProgressIndicator indicator) {
        return indicator instanceof ProgressWrapper ? ((ProgressWrapper)indicator).getOriginalProgressIndicator() : indicator;
    }
}

