/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable builder) {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, builder);
        return progress;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    public static void scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, PooledThreadExecutor.INSTANCE, readTask);
    }

    public static boolean runInReadActionWithWriteActionPriority(final @NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        final Ref result = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(new Runnable(){

            @Override
            public void run() {
                result.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action));
            }
        }, progressIndicator == null ? new ProgressIndicatorBase() : progressIndicator);
        return (Boolean)result.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithWriteActionPriority(final @NotNull Runnable action, final @NotNull ProgressIndicator progressIndicator) {
        final ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isWriteActionPending()) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        final ApplicationAdapter listener2 = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (!progressIndicator.isCanceled()) {
                    progressIndicator.cancel();
                }
            }
        };
        boolean succeededWithAddingListener = application.tryRunReadAction(new Runnable(){

            @Override
            public void run() {
                application.addApplicationListener((ApplicationListener)listener2);
            }
        });
        if (!succeededWithAddingListener) {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
            return false;
        }
        final Ref wasCancelled = new Ref();
        try {
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException ignore) {
                        wasCancelled.set((Object)Boolean.TRUE);
                    }
                }
            }, progressIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener2);
        }
        return wasCancelled.get() != Boolean.TRUE;
    }

    public static void scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, final @NotNull Executor executor, final @NotNull ReadTask readTask) {
        final Application application = ApplicationManager.getApplication();
        EdtInvocationManager.getInstance().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (application.isDisposed()) {
                    return;
                }
                final ApplicationAdapter listener2 = new ApplicationAdapter(){

                    public void beforeWriteActionStart(Object action) {
                        if (!progressIndicator.isCanceled()) {
                            progressIndicator.cancel();
                            readTask.onCanceled(progressIndicator);
                        }
                    }
                };
                application.addApplicationListener((ApplicationListener)listener2);
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean continued = false;
                            try {
                                final ReadTask.Continuation continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                                boolean bl = continued = continuation != null;
                                if (continuation != null) {
                                    application.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            application.removeApplicationListener((ApplicationListener)listener2);
                                            if (!progressIndicator.isCanceled()) {
                                                continuation.getAction().run();
                                            }
                                        }
                                    }, continuation.getModalityState());
                                }
                            }
                            finally {
                                if (!continued) {
                                    application.removeApplicationListener((ApplicationListener)listener2);
                                }
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    application.removeApplicationListener((ApplicationListener)listener2);
                    throw e;
                }
                catch (Error e) {
                    application.removeApplicationListener((ApplicationListener)listener2);
                    throw e;
                }
            }
        });
    }

    private static ReadTask.Continuation runUnderProgress(final @NotNull ProgressIndicator progressIndicator, final @NotNull ReadTask task) {
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess((Computable)new Computable<ReadTask.Continuation>(){

            public ReadTask.Continuation compute() {
                try {
                    return task.runBackgroundProcess(progressIndicator);
                }
                catch (ProcessCanceledException ignore) {
                    return null;
                }
            }
        }, progressIndicator);
    }
}

