/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTasksMonitor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.RunBackgroundable;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlusMinus;
import com.intellij.util.concurrency.QueueProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskQueue {
    private static final String ourMonitorFlag = "monitor.background.queue.load";
    private static final Logger LOG = Logger.getInstance((String)BackgroundTaskQueue.class.getName());
    private final QueueProcessor<Pair<Task.Backgroundable, Getter<ProgressIndicator>>> myProcessor;
    private Boolean myForcedTestMode;
    private final PlusMinus<String> myMonitor;

    public BackgroundTaskQueue(@Nullable Project project2, @NotNull String title) {
        this(project2, title, null);
    }

    public BackgroundTaskQueue(final @Nullable Project project2, @NotNull String title, Boolean forcedHeadlessMode) {
        this.myMonitor = Boolean.TRUE.equals(Boolean.getBoolean(ourMonitorFlag)) ? new BackgroundTasksMonitor(title) : new PlusMinus.Empty();
        boolean headless = forcedHeadlessMode != null ? forcedHeadlessMode.booleanValue() : ApplicationManager.getApplication().isHeadlessEnvironment();
        QueueProcessor.ThreadToUse threadToUse = headless ? QueueProcessor.ThreadToUse.POOLED : QueueProcessor.ThreadToUse.AWT;
        Object consumer = headless ? new BackgroundableHeadlessRunner() : new BackgroundableUnderProgressRunner(title, project2, this.myMonitor);
        this.myProcessor = new QueueProcessor((PairConsumer)consumer, true, threadToUse, (Condition)new Condition<Object>(){

            public boolean value(Object o) {
                if (project2 == null) {
                    return ApplicationManager.getApplication().isDisposed();
                }
                if (project2.isDefault()) {
                    return project2.isDisposed();
                }
                return !ApplicationManager.getApplication().isUnitTestMode() && !project2.isOpen() || project2.isDisposed();
            }
        });
    }

    public void clear() {
        this.myProcessor.clear();
    }

    public boolean isEmpty() {
        return this.myProcessor.isEmpty();
    }

    public void waitForTasksToFinish() {
        this.myProcessor.waitFor();
    }

    public void run(Task.Backgroundable task) {
        this.run(task, null, null);
    }

    public void run(Task.Backgroundable task, ModalityState state, Getter<ProgressIndicator> pi) {
        this.myMonitor.plus((Object)task.getTitle());
        if (this.isTestMode()) {
            RunBackgroundable.runIfBackgroundThread((Task)task, (ProgressIndicator)new EmptyProgressIndicator(), null);
        } else {
            this.myProcessor.add((Object)Pair.create((Object)task, pi), state);
        }
    }

    public boolean isTestMode() {
        if (this.myForcedTestMode != null) {
            return this.myForcedTestMode;
        }
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public void setForcedTestMode(Boolean forcedTestMode, Disposable parentDisposable) {
        this.myForcedTestMode = forcedTestMode;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                BackgroundTaskQueue.this.myForcedTestMode = null;
            }
        });
    }

    private static class BackgroundableUnderProgressRunner
    implements PairConsumer<Pair<Task.Backgroundable, Getter<ProgressIndicator>>, Runnable> {
        private final String myTitle;
        private final Project myProject;
        private final PlusMinus<String> myMonitor;

        public BackgroundableUnderProgressRunner(String title, Project project2, PlusMinus<String> monitor) {
            this.myTitle = title;
            this.myProject = project2;
            this.myMonitor = monitor;
        }

        public void consume(Pair<Task.Backgroundable, Getter<ProgressIndicator>> pair, final Runnable runnable2) {
            this.myMonitor.minus((Object)((Task.Backgroundable)pair.getFirst()).getTitle());
            final Task.Backgroundable backgroundable = (Task.Backgroundable)pair.getFirst();
            final ProgressIndicator[] pi = new ProgressIndicator[1];
            boolean taskTitleIsEmpty = StringUtil.isEmptyOrSpaces((String)backgroundable.getTitle());
            Runnable wrappedTask = new Runnable(){

                @Override
                public void run() {
                    RunBackgroundable.runIfBackgroundThread((Task)backgroundable, (ProgressIndicator)(pi[0] == null ? ProgressManager.getInstance().getProgressIndicator() : pi[0]), (Runnable)runnable2);
                }
            };
            ProgressManager pm = ProgressManager.getInstance();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                pm.runProcessWithProgressSynchronously(wrappedTask, taskTitleIsEmpty ? this.myTitle : backgroundable.getTitle(), backgroundable.isCancellable(), this.myProject);
            } else {
                if (pair.getSecond() != null) {
                    pi[0] = (ProgressIndicator)((Getter)pair.getSecond()).get();
                }
                if (pi[0] == null) {
                    if (taskTitleIsEmpty) {
                        backgroundable.setTitle(this.myTitle);
                    }
                    pi[0] = new BackgroundableProcessIndicator(backgroundable);
                }
                ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(backgroundable, pi[0], runnable2);
            }
        }
    }

    private static class BackgroundableHeadlessRunner
    implements PairConsumer<Pair<Task.Backgroundable, Getter<ProgressIndicator>>, Runnable> {
        private BackgroundableHeadlessRunner() {
        }

        public void consume(Pair<Task.Backgroundable, Getter<ProgressIndicator>> pair, Runnable runnable2) {
            Task.Backgroundable backgroundable = (Task.Backgroundable)pair.getFirst();
            ProgressManager.getInstance().run((Task)backgroundable);
            runnable2.run();
        }
    }
}

