/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPathReferenceProvider
extends PathReferenceProviderBase {
    private boolean myEndingSlashNotAllowed;
    private boolean myRelativePathsAllowed;
    private final FileType[] mySuitableFileTypes;

    public StaticPathReferenceProvider(@Nullable FileType[] suitableFileTypes) {
        this.mySuitableFileTypes = suitableFileTypes;
    }

    @Override
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, final boolean soft) {
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, this.myEndingSlashNotAllowed, this.mySuitableFileTypes){

            @Override
            protected boolean isUrlEncoded() {
                return true;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
        if (!this.myRelativePathsAllowed) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        Collections.addAll(references, set.getAllReferences());
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        SmartList list = new SmartList();
        this.createReferences(element, (List<PsiReference>)list, true);
        if (list.isEmpty()) {
            return null;
        }
        final PsiElement target = ((PsiReference)list.get(list.size() - 1)).resolve();
        if (target == null) {
            return null;
        }
        return new PathReference(path, (Function)PathReference.ResolveFunction.NULL_RESOLVE_FUNCTION){

            public PsiElement resolve() {
                return target;
            }
        };
    }

    public void setEndingSlashNotAllowed(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    public void setRelativePathsAllowed(boolean relativePathsAllowed) {
        this.myRelativePathsAllowed = relativePathsAllowed;
    }
}

