/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project2, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(project2, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, project2);
    }

    public SettingsDialog(@NotNull Component parent, String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        super(parent, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable, null);
    }

    public SettingsDialog(@NotNull Project project2, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter) {
        super(project2, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project2, groups, configurable, filter);
        this.myApplyButtonNeeded = true;
        this.init(null, project2);
    }

    public void show() {
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                SettingsDialog.super.show();
            }
        });
    }

    private void init(Configurable configurable, @Nullable Project project2) {
        String name = configurable == null ? null : configurable.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project2 != null && project2.isDefault()) {
            title = "Default " + title;
        }
        this.setTitle(name == null ? title : name.replace('\n', ' '));
        this.init();
    }

    public Object getData(@NonNls String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    @NotNull
    protected Action[] createActions() {
        String topic;
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply = this.myEditor.getApplyAction();
        if (apply != null && this.myApplyButtonNeeded) {
            actions.add(apply);
        }
        if ((reset = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset);
        }
        if ((topic = this.myEditor.getHelpTopic()) != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected void doHelpAction() {
        String topic = this.myEditor.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public void doOKAction() {
        if (this.myEditor.apply()) {
            ApplicationManager.getApplication().saveAll();
            SettingsDialog.super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }
}

