/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.ActionCallback;
import java.util.IdentityHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Settings {
    public static final DataKey<Settings> KEY = DataKey.create((String)"settings.editor");
    private final ConfigurableGroup[] myGroups;
    private final IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper> myMap = new IdentityHashMap();

    protected Settings(ConfigurableGroup ... groups) {
        this.myGroups = groups;
    }

    @Nullable
    public final <T extends Configurable> T find(@NotNull Class<T> type) {
        return this.unwrap(new ConfigurableVisitor.ByType(type).find(this.myGroups), type);
    }

    @Nullable
    public final Configurable find(@NotNull String id) {
        return this.unwrap(new ConfigurableVisitor.ByID(id).find(this.myGroups), Configurable.class);
    }

    @NotNull
    public final ActionCallback select(Configurable configurable) {
        return configurable != null ? this.selectImpl(Settings.choose(configurable, (Configurable)this.myMap.get(configurable))) : ActionCallback.REJECTED;
    }

    protected abstract ActionCallback selectImpl(Configurable var1);

    private <T extends Configurable> T unwrap(Configurable configurable, Class<T> type) {
        Configurable result = (Configurable)ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable);
        if (result != null && configurable instanceof ConfigurableWrapper) {
            this.myMap.put((UnnamedConfigurable)result, (ConfigurableWrapper)configurable);
        }
        return (T)result;
    }

    private static Configurable choose(Configurable configurable, Configurable variant) {
        return variant != null ? variant : configurable;
    }
}

