/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedConfigurable
extends CompositeConfigurable<Configurable> {
    protected TabbedPaneWrapper myTabbedPane;
    private final Disposable myParent;

    protected TabbedConfigurable(@NotNull Disposable parent) {
        this.myParent = parent;
    }

    public JComponent createComponent() {
        this.myTabbedPane = new TabbedPaneWrapper(this.myParent);
        this.createConfigurableTabs();
        JComponent component = this.myTabbedPane.getComponent();
        component.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return component;
    }

    protected void createConfigurableTabs() {
        for (Configurable configurable : this.getConfigurables()) {
            this.myTabbedPane.addTab(configurable.getDisplayName(), configurable.createComponent());
        }
    }

    @Override
    public void disposeUIResources() {
        this.myTabbedPane = null;
        super.disposeUIResources();
    }
}

