/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundScheme<E extends SchemeElement>
extends ExternalizableSchemeAdapter {
    protected final ArrayList<E> myElements = new ArrayList();

    public CompoundScheme(String name) {
        this.myName = name;
    }

    public final void addElement(E t) {
        if (!this.contains(t)) {
            this.myElements.add(t);
        }
    }

    @NotNull
    public final List<E> getElements() {
        return Collections.unmodifiableList(new ArrayList<E>(this.myElements));
    }

    public final void setName(@NotNull String name) {
        this.myName = name;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name);
        }
    }

    public final void removeElement(E template) {
        Iterator<E> templateIterator = this.myElements.iterator();
        while (templateIterator.hasNext()) {
            SchemeElement t = (SchemeElement)templateIterator.next();
            if (t.getKey() == null || !t.getKey().equals(template.getKey())) continue;
            templateIterator.remove();
        }
    }

    public final boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    @NotNull
    private CompoundScheme<E> createNewInstance(String name) {
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(String.class);
            try {
                constructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (CompoundScheme)((Object)constructor.newInstance(name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    CompoundScheme<E> copy() {
        CompoundScheme<E> result = this.createNewInstance(this.getName());
        result.resetFrom(this);
        return result;
    }

    void resetFrom(@NotNull CompoundScheme<E> template) {
        this.myElements.clear();
        this.myElements.ensureCapacity(template.myElements.size());
        for (SchemeElement element : template.myElements) {
            this.myElements.add(element.copy());
        }
    }

    public boolean contains(@NotNull E element) {
        for (SchemeElement t : this.myElements) {
            String key = t.getKey();
            if (key == null || !key.equals(element.getKey())) continue;
            return true;
        }
        return false;
    }

    public static final class MutatorHelper<T extends CompoundScheme<E>, E extends SchemeElement> {
        private final THashMap<T, T> copiedToOriginal = new THashMap(ContainerUtil.identityStrategy());

        @NotNull
        public T copy(@NotNull T scheme) {
            CompoundScheme copied = ((CompoundScheme)((Object)scheme)).copy();
            this.copiedToOriginal.put(copied, scheme);
            return (T)((Object)copied);
        }

        @NotNull
        public List<T> apply(final @NotNull List<T> copiedSchemes) {
            this.copiedToOriginal.retainEntries(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T copied, T original) {
                    return ContainerUtil.containsIdentity((Iterable)copiedSchemes, copied);
                }
            });
            ArrayList originals = new ArrayList(copiedSchemes.size());
            for (CompoundScheme copied : copiedSchemes) {
                CompoundScheme original = (CompoundScheme)((Object)this.copiedToOriginal.remove((Object)copied));
                if (original == null) {
                    original = copied.copy();
                    this.copiedToOriginal.put((Object)copied, original);
                } else {
                    original.resetFrom(copied);
                }
                originals.add(original);
            }
            return originals;
        }

        public void clear() {
            this.copiedToOriginal.clear();
        }
    }
}

