/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsTestScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module myModule;
    private final ConcurrentIntObjectMap<GlobalSearchScope> myScopeCache = ContainerUtil.createConcurrentIntObjectMap();
    private ModuleWithDependentsTestScope myModuleTestsWithDependentsScope;

    public ModuleScopeProviderImpl(@NotNull Module module2) {
        this.myModule = module2;
    }

    @NotNull
    private GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = (GlobalSearchScope)this.myScopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.myModule, options);
            this.myScopeCache.put(options, (Object)scope);
        }
        return scope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.getCachedScope(9);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.getCachedScope(1 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.getCachedScope(11);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.getCachedScope(13);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.getCachedScope(32);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.getCachedScope(36);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.getCachedScope(7 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        return this.getModuleTestsWithDependentsScope().getBaseScope();
    }

    @NotNull
    public ModuleWithDependentsTestScope getModuleTestsWithDependentsScope() {
        ModuleWithDependentsTestScope scope = this.myModuleTestsWithDependentsScope;
        if (scope == null) {
            this.myModuleTestsWithDependentsScope = scope = new ModuleWithDependentsTestScope(this.myModule);
        }
        return scope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.getCachedScope(6 | (includeTests ? 8 : 0));
    }

    @Override
    public void clearCache() {
        this.myScopeCache.clear();
        this.myModuleTestsWithDependentsScope = null;
    }
}

