/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final Set<VirtualFile> myEntries = new LinkedHashSet<VirtualFile>();
    private int myCachedHashCode;

    public LibraryRuntimeClasspathScope(@NotNull Project project2, @NotNull Module[] modules) {
        super(project2);
        this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        THashSet processedSdk = new THashSet();
        THashSet processedLibraries = new THashSet();
        THashSet processedModules = new THashSet();
        Condition<OrderEntry> condition = new Condition<OrderEntry>((Set)processedModules){
            final /* synthetic */ Set val$processedModules;
            {
                this.val$processedModules = set;
            }

            public boolean value(OrderEntry orderEntry) {
                if (orderEntry instanceof ModuleOrderEntry) {
                    Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
                    return module2 != null && !this.val$processedModules.contains(module2);
                }
                return true;
            }
        };
        for (Module module2 : modules) {
            this.buildEntries(module2, (Set<Module>)processedModules, (Set<Library>)processedLibraries, (Set<Sdk>)processedSdk, condition);
        }
    }

    public LibraryRuntimeClasspathScope(@NotNull Project project2, @NotNull LibraryOrderEntry entry) {
        super(project2);
        this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.CLASSES));
    }

    public int hashCode() {
        if (this.myCachedHashCode == 0) {
            this.myCachedHashCode = this.myEntries.hashCode();
        }
        return this.myCachedHashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)((Object)object);
        return that.myEntries.equals(this.myEntries);
    }

    private void buildEntries(@NotNull Module module2, final @NotNull Set<Module> processedModules, final @NotNull Set<Library> processedLibraries, final @NotNull Set<Sdk> processedSdk, @NotNull Condition<OrderEntry> condition) {
        if (!processedModules.add(module2)) {
            return;
        }
        ModuleRootManager.getInstance((Module)module2).orderEntries().recursively().satisfying(condition).process((RootPolicy)new RootPolicy<Set<VirtualFile>>(){

            public Set<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Set<VirtualFile> value) {
                Library library = libraryOrderEntry.getLibrary();
                if (library != null && processedLibraries.add(library)) {
                    ContainerUtil.addAll(value, (Object[])libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
                }
                return value;
            }

            public Set<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry moduleSourceOrderEntry, Set<VirtualFile> value) {
                processedModules.add(moduleSourceOrderEntry.getOwnerModule());
                ContainerUtil.addAll(value, (Object[])moduleSourceOrderEntry.getRootModel().getSourceRoots());
                return value;
            }

            public Set<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Set<VirtualFile> value) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null) {
                    ContainerUtil.addAll(value, (Object[])ModuleRootManager.getInstance((Module)depModule).getSourceRoots());
                }
                return value;
            }

            public Set<VirtualFile> visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, Set<VirtualFile> value) {
                Sdk jdk = jdkOrderEntry.getJdk();
                if (jdk != null && processedSdk.add(jdk)) {
                    ContainerUtil.addAll(value, (Object[])jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
                }
                return value;
            }
        }, this.myEntries);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.myEntries.contains(this.getFileRoot(file2));
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (this.myIndex.isLibraryClassFile(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        if (this.myIndex.isInContent(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        return null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (Comparing.equal((Object)r1, (Object)root)) {
                return 1;
            }
            if (!Comparing.equal((Object)r2, (Object)root)) continue;
            return -1;
        }
        return 0;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        return new ArrayList<VirtualFile>(this.myEntries);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

