/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ModulePointerManagerImpl
extends ModulePointerManager {
    private final Map<String, ModulePointerImpl> myUnresolved = new HashMap<String, ModulePointerImpl>();
    private final Map<Module, ModulePointerImpl> myPointers = new HashMap<Module, ModulePointerImpl>();
    private final Project myProject;

    public ModulePointerManagerImpl(Project project2) {
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                ModulePointerManagerImpl.this.unregisterPointer(module2);
            }

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                ModulePointerManagerImpl.this.moduleAppears(module2);
            }

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                for (Module module2 : modules) {
                    ModulePointerManagerImpl.this.moduleAppears(module2);
                }
            }
        });
    }

    private void moduleAppears(Module module2) {
        ModulePointerImpl pointer = this.myUnresolved.remove(module2.getName());
        if (pointer != null && pointer.getModule() == null) {
            pointer.moduleAdded(module2);
            this.registerPointer(module2, pointer);
        }
    }

    private void registerPointer(final Module module2, ModulePointerImpl pointer) {
        this.myPointers.put(module2, pointer);
        Disposer.register((Disposable)module2, (Disposable)new Disposable(){

            public void dispose() {
                ModulePointerManagerImpl.this.unregisterPointer(module2);
            }
        });
    }

    private void unregisterPointer(Module module2) {
        ModulePointerImpl pointer = this.myPointers.remove(module2);
        if (pointer != null) {
            pointer.moduleRemoved(module2);
            this.myUnresolved.put(pointer.getModuleName(), pointer);
        }
    }

    @NotNull
    public ModulePointer create(@NotNull Module module2) {
        ModulePointerImpl pointer = this.myPointers.get(module2);
        if (pointer == null) {
            pointer = this.myUnresolved.get(module2.getName());
            if (pointer == null) {
                pointer = new ModulePointerImpl(module2);
            } else {
                pointer.moduleAdded(module2);
            }
            this.registerPointer(module2, pointer);
        }
        return pointer;
    }

    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        Module module2 = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName);
        if (module2 != null) {
            return this.create(module2);
        }
        ModulePointerImpl pointer = this.myUnresolved.get(moduleName);
        if (pointer == null) {
            pointer = new ModulePointerImpl(moduleName);
            this.myUnresolved.put(moduleName, pointer);
        }
        return pointer;
    }
}

