/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectModuleManager", storages={@Storage(value="modules.xml")})
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerComponent");
    private final ProgressManager myProgressManager;
    private final MessageBusConnection myConnection;

    public ModuleManagerComponent(Project project2, ProgressManager progressManager, MessageBus bus) {
        super(project2, bus);
        this.myConnection = bus.connect((Disposable)project2);
        this.myProgressManager = progressManager;
        this.myConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModuleManagerComponent.this.cleanCachedStuff();
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        this.myConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

            public void projectComponentsInitialized(@NotNull Project project2) {
                if (project2 != ModuleManagerComponent.this.myProject) {
                    return;
                }
                long t = System.currentTimeMillis();
                ModuleManagerComponent.this.loadModules(ModuleManagerComponent.this.myModuleModel);
                t = System.currentTimeMillis() - t;
                LOG.info(ModuleManagerComponent.this.myModuleModel.getModules().length + " module(s) loaded in " + t + " ms");
            }
        });
    }

    @Override
    protected void showUnknownModuleTypeNotification(@NotNull List<Module> modulesWithUnknownTypes) {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message;
            if (modulesWithUnknownTypes.size() == 1) {
                message = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module2 : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module2.getName()).append("\" (type '").append(ModuleType.get((Module)module2).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification("Module Manager", ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        return new ModuleImpl(filePath, this.myProject);
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) {
        return new ModuleImpl(filePath, this.myProject);
    }

    @Override
    protected boolean isUnknownModuleType(@NotNull Module module2) {
        return ModuleType.get((Module)module2) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        if (this.myModuleModel.myModules.isEmpty()) {
            return;
        }
        Runnable runnableWithProgress = new Runnable(){

            @Override
            public void run() {
                for (final Module module2 : ModuleManagerComponent.this.myModuleModel.myModules.values()) {
                    Application app = ApplicationManager.getApplication();
                    Runnable swingRunnable = new Runnable(){

                        @Override
                        public void run() {
                            ModuleManagerComponent.this.fireModuleAddedInWriteAction(module2);
                        }
                    };
                    ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                    app.invokeAndWait(swingRunnable, pi.getModalityState());
                }
            }
        };
        ProgressIndicator progressIndicator = this.myProgressManager.getProgressIndicator();
        if (progressIndicator == null) {
            this.myProgressManager.runProcessWithProgressSynchronously(runnableWithProgress, "Initializing modules...", false, this.myProject);
        } else {
            runnableWithProgress.run();
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myConnection.deliverImmediately();
    }
}

