/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.ModuleServiceManagerImpl;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ModuleImpl
extends PlatformComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleImpl");
    @NotNull
    private final Project myProject;
    private boolean isModuleAdded;
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    public ModuleImpl(@NotNull String filePath, @NotNull Project project2) {
        super((ComponentManager)project2, "Module " + ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath)));
        this.getPicoContainer().registerComponentInstance(Module.class, (Object)this);
        this.myProject = project2;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath));
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this);
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, (AreaInstance)((AreaInstance)this.getParentComponentManager()));
        super.bootstrapPicoContainer(name);
    }

    @Override
    public void init(final @NotNull String path, final @Nullable Runnable beforeComponentCreation) {
        this.init(ProgressManager.getInstance().getProgressIndicator(), new Runnable(){

            @Override
            public void run() {
                ModuleImpl.this.getPicoContainer().getComponentInstance(ModuleServiceManagerImpl.class);
                ServiceKt.getStateStore(ModuleImpl.this).setPath(path);
                if (beforeComponentCreation != null) {
                    beforeComponentCreation.run();
                }
            }
        });
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
    }

    @Override
    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        if (!super.isComponentSuitable(options)) {
            return false;
        }
        if (options == null || options.isEmpty()) {
            return true;
        }
        for (String optionName : options.keySet()) {
            if ("workspace".equals(optionName)) continue;
            String message = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
                continue;
            }
            LOG.warn(message);
        }
        return true;
    }

    @Nullable
    public VirtualFile getModuleFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.getModuleFilePath());
    }

    @Override
    public void rename(String newName) {
        this.myName = newName;
        ServiceKt.getStateStore(this).getStateStorageManager().rename("$MODULE_FILE$", newName + ".iml");
    }

    @NotNull
    public String getModuleFilePath() {
        return ServiceKt.getStateStore(this).getStateStorageManager().expandMacros("$MODULE_FILE$");
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
    }

    @Override
    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        return plugin.getModuleComponents();
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        List<ModuleComponent> components = this.getComponentInstancesOfType(ModuleComponent.class);
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            component.moduleAdded();
        }
    }

    public void setOption(@NotNull String key, @NotNull String value) {
        ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.put(key, value);
    }

    @NotNull
    private DeprecatedModuleOptionManager getOptionManager() {
        return (DeprecatedModuleOptionManager)ModuleServiceManager.getService((Module)this, DeprecatedModuleOptionManager.class);
    }

    public void clearOption(@NotNull String key) {
        ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.remove(key);
    }

    public String getOptionValue(@NotNull String key) {
        return ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.get(key);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.myModuleScopeProvider.getModuleScope();
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.myModuleScopeProvider.getModuleWithLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.myModuleScopeProvider.getModuleContentScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    private static String moduleNameByFileName(@NotNull String fileName) {
        return StringUtil.trimEnd((String)fileName, (String)".iml");
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    @com.intellij.openapi.components.State(name="DeprecatedModuleOptionManager")
    static class DeprecatedModuleOptionManager
    implements PersistentStateComponent<State> {
        private State state = new State();

        DeprecatedModuleOptionManager() {
        }

        @Nullable
        public State getState() {
            return this.state;
        }

        public void loadState(State state) {
            this.state = state;
        }

        static final class State {
            @Property(surroundWithTag=false)
            @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false, entryTagName="option")
            public final Map<String, String> options = new THashMap();

            State() {
            }
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            String moduleFilePath;
            String parentPath;
            String ancestorPath;
            if (!ModuleImpl.this.isModuleAdded || event.getRequestor() instanceof StateStorage || !"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile parent = event.getParent();
            if (parent != null && FileUtil.isAncestor((String)(ancestorPath = (parentPath = parent.getPath()) + "/" + event.getOldValue()), (String)(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                this.setModuleFilePath(parentPath + "/" + event.getNewValue() + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
            }
        }

        private void setModuleFilePath(String newFilePath) {
            ClasspathStorage.modulePathChanged(ModuleImpl.this, newFilePath);
            ServiceKt.getStateStore(ModuleImpl.this).setPath(FileUtilRt.toSystemIndependentName((String)newFilePath));
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String moduleFilePath;
            String dirName = event.getFileName();
            String ancestorPath = event.getOldParent().getPath() + "/" + dirName;
            if (FileUtil.isAncestor((String)ancestorPath, (String)(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                this.setModuleFilePath(event.getNewParent().getPath() + "/" + dirName + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
            }
        }
    }
}

