/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;

public final class ShortcutTextField
extends JTextField {
    private KeyStroke myKeyStroke;

    ShortcutTextField() {
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(false);
        this.setCaret(new DefaultCaret(){

            @Override
            public boolean isVisible() {
                return false;
            }
        });
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyCode;
        if (e.getID() == 401 && (keyCode = e.getKeyCode()) != 16 && keyCode != 18 && keyCode != 17 && keyCode != 65406 && keyCode != 157) {
            this.setKeyStroke(KeyStrokeAdapter.getDefaultKeyStroke(e));
        }
        if (ScreenReader.isActive()) {
            this.setFocusTraversalKeysEnabled(true);
            try {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent(this, e);
            }
            finally {
                this.setFocusTraversalKeysEnabled(false);
            }
        }
    }

    void setKeyStroke(KeyStroke keyStroke) {
        KeyStroke old = this.myKeyStroke;
        if (old != null || keyStroke != null) {
            this.myKeyStroke = keyStroke;
            super.setText(KeymapUtil.getKeystrokeText((KeyStroke)keyStroke));
            this.setCaretPosition(0);
            this.firePropertyChange("keyStroke", old, keyStroke);
        }
    }

    KeyStroke getKeyStroke() {
        return this.myKeyStroke;
    }

    @Override
    public void enableInputMethods(boolean enable) {
        super.enableInputMethods(enable && Registry.is((String)"ide.settings.keymap.input.method.enabled"));
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setCaretPosition(0);
        if (text == null || text.isEmpty()) {
            this.myKeyStroke = null;
            this.firePropertyChange("keyStroke", null, null);
        }
    }
}

