/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.ComboBoxModelEditor;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private static final Condition<Keymap> KEYMAP_FILTER = new Condition<Keymap>(){

        public boolean value(Keymap keymap) {
            return !SystemInfo.isMac || !"$default".equals(keymap.getName());
        }
    };
    private final ComboBoxModelEditor<Keymap> myEditor = new ComboBoxModelEditor<Keymap>(new ListItemEditor<Keymap>(){

        @Override
        @NotNull
        public String getName(@NotNull Keymap item) {
            String name = item.getPresentableName();
            return name == null ? KeyMapBundle.message((String)"keymap.noName.presentable.name", (Object[])new Object[0]) : name;
        }

        @Override
        @NotNull
        public Class<? extends Keymap> getItemClass() {
            return KeymapImpl.class;
        }

        @Override
        public Keymap clone(@NotNull Keymap item, boolean forInPlaceEditing) {
            return ((KeymapImpl)item).copy();
        }

        @Override
        public void applyModifiedProperties(@NotNull Keymap newItem, @NotNull Keymap oldItem) {
            ((KeymapImpl)newItem).copyTo((KeymapImpl)oldItem);
        }

        @Override
        public boolean isRemovable(@NotNull Keymap item) {
            return item.canModify();
        }

        @Override
        public boolean isEditable(@NotNull Keymap item) {
            return item.canModify();
        }
    });
    private JButton myCopyButton;
    private JButton myDeleteButton;
    private JButton myResetToDefault;
    private JCheckBox myNonEnglishKeyboardSupportOption;
    private JLabel myBaseKeymapLabel;
    private ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add((Component)this.createKeymapListPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(QuickList oldQuickList, QuickList newQuickList) {
        for (Keymap keymap : this.myEditor.getModel().getItems()) {
            String actionId;
            Shortcut[] shortcuts = keymap.getShortcuts(actionId = oldQuickList.getActionId());
            if (shortcuts.length == 0) continue;
            String newActionId = newQuickList.getActionId();
            for (Shortcut shortcut : shortcuts) {
                keymap.removeShortcut(actionId, shortcut);
                keymap.addShortcut(newActionId, shortcut);
            }
        }
        this.myQuickListsModified = true;
    }

    private JPanel createKeymapListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel keymapLabel = new JLabel(KeyMapBundle.message((String)"keymaps.border.factory.title", (Object[])new Object[0]));
        keymapLabel.setLabelFor((Component)this.myEditor.getComboBox());
        panel.add((Component)keymapLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myEditor.getComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.createKeymapButtonsPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myEditor.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                KeymapPanel.this.currentKeymapChanged();
            }
        });
        panel.add((Component)this.createKeymapNamePanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                KeymapPanel.this.showOption(option);
            }
        };
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(@NotNull QuickList[] ids) {
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.myResetToDefault.setEnabled(false);
        Keymap selectedKeymap = (Keymap)this.myEditor.getModel().getSelected();
        boolean editable = selectedKeymap != null && selectedKeymap.canModify();
        this.myDeleteButton.setEnabled(editable);
        this.myCopyButton.setEnabled(selectedKeymap != null);
        this.myEditor.getComboBox().setEditable(editable);
        if (selectedKeymap == null) {
            this.myActionsTree.reset(new KeymapImpl(), this.myQuickLists);
            return;
        }
        Keymap parent = selectedKeymap.getParent();
        if (parent == null || !selectedKeymap.canModify()) {
            this.myBaseKeymapLabel.setText("");
        } else {
            this.myBaseKeymapLabel.setText(KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{parent.getPresentableName()}));
            if (selectedKeymap.canModify() && ((KeymapImpl)selectedKeymap).getOwnActionIds().length > 0) {
                this.myResetToDefault.setEnabled(true);
            }
        }
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
    }

    private JPanel createKeymapButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        panel.setLayout(new GridBagLayout());
        this.myCopyButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"copy.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.copyKeymap();
            }
        });
        Insets insets = new Insets(2, 2, 2, 2);
        this.myCopyButton.setMargin(insets);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        panel.add((Component)this.myCopyButton, gc);
        this.myResetToDefault = new JButton(CommonBundle.message((String)"button.reset", (Object[])new Object[0]));
        this.myResetToDefault.setMargin(insets);
        panel.add((Component)this.myResetToDefault, gc);
        this.myDeleteButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"delete.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.deleteKeymap();
            }
        });
        this.myDeleteButton.setMargin(insets);
        gc.weightx = 1.0;
        panel.add((Component)this.myDeleteButton, gc);
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            String displayLanguage = ideFrame.getComponent().getInputContext().getLocale().getDisplayLanguage();
            this.myNonEnglishKeyboardSupportOption = new JCheckBox(new AbstractAction(displayLanguage + " " + KeyMapBundle.message((String)"use.non.english.keyboard.layout.support", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(KeymapPanel.this.myNonEnglishKeyboardSupportOption.isSelected());
                }
            });
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
            panel.add((Component)this.myNonEnglishKeyboardSupportOption, gc);
        }
        this.myResetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                KeymapPanel.this.resetKeymap();
            }
        });
        return panel;
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myActionsTree = new ActionsTree();
        panel.add((Component)this.createToolbarPanel(), "North");
        panel.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }
        });
        return panel;
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)KeymapPanel.this.myActionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction("Edit Shortcut", "Edit Shortcut", AllIcons.ToolbarDecorator.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.editSelection(e.getInputEvent());
            }
        });
        panel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        group = new DefaultActionGroup();
        final JComponent searchToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                            return;
                        }
                        KeymapPanel.this.myTreeExpansionMonitor.freeze();
                        String filter = this.getFilter();
                        KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.myQuickLists);
                        JTree tree = KeymapPanel.this.myActionsTree.getTree();
                        TreeUtil.expandAll((JTree)tree);
                        if (filter == null || filter.length() == 0) {
                            TreeUtil.collapseAll((JTree)tree, (int)0);
                            KeymapPanel.this.myTreeExpansionMonitor.restore();
                        } else {
                            KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                        }
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myFilterComponent.reset();
                KeymapPanel.this.myActionsTree.reset((Keymap)KeymapPanel.this.myEditor.getModel().getSelected(), KeymapPanel.this.myQuickLists);
                KeymapPanel.this.myFilteringPanel.showPopup(searchToolbar);
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void actionPerformed(@NotNull AnActionEvent e) {
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createKeymapNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myBaseKeymapLabel = new JLabel(KeyMapBundle.message((String)"parent.keymap.label", (Object[])new Object[0]));
        panel.add((Component)this.myBaseKeymapLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        return panel;
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        this.myTreeExpansionMonitor.freeze();
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
        this.myTreeExpansionMonitor.restore();
    }

    public void showOption(String option) {
        this.myActionsTree.reset((Keymap)this.myEditor.getModel().getSelected(), this.myQuickLists);
        this.myFilterComponent.setFilter(option);
        this.myActionsTree.filter(option, this.myQuickLists);
    }

    private void addKeyboardShortcut(@NotNull String actionId, @Nullable Shortcut shortcut) {
        Keymap keymapSelected = (Keymap)this.myEditor.getModel().getSelected();
        assert (keymapSelected != null);
        KeymapPanel.addKeyboardShortcut(actionId, shortcut, keymapSelected, this, this.myQuickLists);
        this.repaintLists();
        this.currentKeymapChanged();
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @Nullable Shortcut shortcut, @NotNull Keymap keymapSelected, @NotNull Component parent, @NotNull QuickList[] quickLists) {
        Shortcut[] shortcuts;
        KeyboardShortcutDialog dialog = new KeyboardShortcutDialog(parent);
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)dialog.showAndGet(shortcut, actionId, keymapSelected, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        Keymap keymap = null;
        if (dialog.hasConflicts()) {
            int result = KeymapPanel.showConfirmationDialog(parent);
            if (result == 0) {
                keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
                Map conflicts = keymap.getConflicts(actionId, keyboardShortcut);
                for (String id : conflicts.keySet()) {
                    for (KeyboardShortcut s : (ArrayList)conflicts.get(id)) {
                        keymap.removeShortcut(id, (Shortcut)s);
                    }
                }
            } else if (result != 1) {
                return;
            }
        }
        if (keymap == null) {
            keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
        }
        for (Shortcut s : shortcuts = keymap.getShortcuts(actionId)) {
            if (!s.equals(keyboardShortcut)) continue;
            return;
        }
        keymap.addShortcut(actionId, (Shortcut)keyboardShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            keymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)keyboardShortcut);
        }
    }

    private void addMouseShortcut(Shortcut shortcut, ShortcutRestrictions restrictions) {
        Shortcut[] shortcuts;
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        MouseShortcutDialog dialog = new MouseShortcutDialog(this, restrictions.allowMouseDoubleClick);
        Keymap keymapSelected = (Keymap)this.myEditor.getModel().getSelected();
        MouseShortcut mouseShortcut = (MouseShortcut)dialog.showAndGet(shortcut, actionId, keymapSelected, this.myQuickLists);
        if (mouseShortcut == null) {
            return;
        }
        Keymap keymap = null;
        if (dialog.hasConflicts()) {
            int result = KeymapPanel.showConfirmationDialog(this);
            if (result == 0) {
                String[] actionIds;
                keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(this, keymapSelected);
                String[] stringArray = actionIds = keymap.getActionIds(mouseShortcut);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String id = stringArray[i];
                    keymap.removeShortcut(id, (Shortcut)mouseShortcut);
                }
            } else if (result != 1) {
                return;
            }
        }
        if (keymap == null) {
            keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(this, keymapSelected);
        }
        for (Shortcut shortcut1 : shortcuts = keymap.getShortcuts(actionId)) {
            if (!shortcut1.equals(mouseShortcut)) continue;
            return;
        }
        keymap.addShortcut(actionId, (Shortcut)mouseShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            keymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)mouseShortcut);
        }
        this.repaintLists();
        this.currentKeymapChanged();
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @NotNull
    private static Keymap createKeymapCopyIfNeededAndPossible(Component parent, Keymap keymap) {
        if (parent instanceof KeymapPanel) {
            KeymapPanel panel = (KeymapPanel)parent;
            keymap = panel.createKeymapCopyIfNeeded();
        }
        return keymap;
    }

    @NotNull
    private Keymap createKeymapCopyIfNeeded() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        assert (keymap != null);
        if (keymap.canModify()) {
            Keymap mutable = this.myEditor.getMutable(keymap);
            this.myActionsTree.setKeymap(mutable);
            return mutable;
        }
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        KeymapImpl newKeymap = ((KeymapImpl)keymap).deriveKeymap();
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        int indexOf = this.myEditor.getModel().getElementIndex((Object)keymap);
        if (indexOf >= 0) {
            this.myEditor.getModel().add(indexOf + 1, (Object)newKeymap);
        } else {
            this.myEditor.getModel().add((Object)newKeymap);
        }
        this.myEditor.getModel().setSelectedItem((Object)newKeymap);
        this.currentKeymapChanged();
        return newKeymap;
    }

    private void copyKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null) {
            return;
        }
        KeymapImpl newKeymap = ((KeymapImpl)keymap).deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        this.myEditor.getModel().add((Object)newKeymap);
        this.myEditor.getModel().setSelectedItem((Object)newKeymap);
        this.myEditor.getComboBox().getEditor().selectAll();
        this.currentKeymapChanged();
    }

    private boolean tryNewKeymapName(String name) {
        for (int i = 0; i < this.myEditor.getModel().getSize(); ++i) {
            if (!name.equals(((Keymap)this.myEditor.getModel().getElementAt(i)).getPresentableName())) continue;
            return false;
        }
        return true;
    }

    private void deleteKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null || Messages.showYesNoDialog((Component)this, (String)KeyMapBundle.message((String)"delete.keymap.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"delete.keymap.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        this.myEditor.getModel().remove((Object)keymap);
        this.currentKeymapChanged();
    }

    private void resetKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null) {
            return;
        }
        ((KeymapImpl)keymap).clearOwnActionsIds();
        this.currentKeymapChanged();
    }

    @NotNull
    public String getId() {
        return "preferences.keymap";
    }

    public void reset() {
        if (this.myNonEnglishKeyboardSupportOption != null) {
            KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(false);
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
        }
        Keymap selectedKeymap = null;
        List<Keymap> list = KeymapPanel.getManagerKeymaps();
        for (Keymap keymap : list) {
            if (selectedKeymap != null || keymap != KeymapManagerEx.getInstanceEx().getActiveKeymap()) continue;
            selectedKeymap = keymap;
        }
        this.myEditor.reset(list);
        if (this.myEditor.getModel().isEmpty()) {
            KeymapImpl keymap = new KeymapImpl();
            keymap.setName(KeyMapBundle.message((String)"keymap.no.name", (Object[])new Object[0]));
            this.myEditor.getModel().add((Object)keymap);
            selectedKeymap = keymap;
        }
        this.myEditor.getModel().setSelectedItem((Object)selectedKeymap);
        this.currentKeymapChanged();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.ensureNonEmptyNames(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.non.empty.names.error.message", (Object[])new Object[0]));
        this.ensureUniqueKeymapNames();
        KeymapManagerImpl keymapManager = (KeymapManagerImpl)KeymapManager.getInstance();
        keymapManager.setKeymaps(this.myEditor.apply(), (Keymap)this.myEditor.getModel().getSelected(), KEYMAP_FILTER);
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    private void ensureUniqueKeymapNames() throws ConfigurationException {
        THashSet keymapNames = new THashSet();
        for (Keymap keymap : this.myEditor.getModel().getItems()) {
            if (keymapNames.add(keymap.getName())) continue;
            throw new ConfigurationException(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]));
        }
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.myEditor.getModel().getSelected(), (Object)KeymapManager.getInstance().getActiveKeymap()) || this.myEditor.isModified();
    }

    @NotNull
    private static List<Keymap> getManagerKeymaps() {
        return ((KeymapManagerImpl)KeymapManagerEx.getInstanceEx()).getKeymaps(KEYMAP_FILTER);
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
        return this;
    }

    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public Shortcut[] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        return keymap == null ? null : keymap.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        DefaultActionGroup group = this.createEditActionGroup(actionId);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Edit Shortcuts", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(final @NotNull String actionId) {
        DefaultActionGroup group = new DefaultActionGroup();
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Keyboard Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Shortcut firstShortcut = null;
                    Keymap keymap = (Keymap)KeymapPanel.this.myEditor.getModel().getSelected();
                    assert (keymap != null);
                    for (Shortcut shortcut : keymap.getShortcuts(actionId)) {
                        if (!(shortcut instanceof KeyboardShortcut)) continue;
                        firstShortcut = shortcut;
                        break;
                    }
                    KeymapPanel.this.addKeyboardShortcut(actionId, firstShortcut);
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Mouse Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Shortcut firstMouse = null;
                    Keymap keymap = (Keymap)KeymapPanel.this.myEditor.getModel().getSelected();
                    assert (keymap != null);
                    for (Shortcut shortcut : keymap.getShortcuts(actionId)) {
                        if (!(shortcut instanceof MouseShortcut)) continue;
                        firstMouse = shortcut;
                        break;
                    }
                    KeymapPanel.this.addMouseShortcut(firstMouse, restrictions);
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction("Add Abbreviation"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String abbr = Messages.showInputDialog((String)"Enter new abbreviation:", (String)"Abbreviation", null);
                    if (abbr != null) {
                        AbbreviationManager.getInstance().register(abbr, KeymapPanel.this.myActionsTree.getSelectedActionId());
                        KeymapPanel.this.repaintLists();
                    }
                }

                public void update(@NotNull AnActionEvent e) {
                    e.getPresentation().setEnabledAndVisible(KeymapPanel.this.myActionsTree.getSelectedActionId() != null);
                }
            });
        }
        group.addSeparator();
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        assert (keymap != null);
        for (final Shortcut shortcut : keymap.getShortcuts(actionId)) {
            group.add((AnAction)new DumbAwareAction("Remove " + KeymapUtil.getShortcutText((Shortcut)shortcut)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Keymap keymap = KeymapPanel.this.createKeymapCopyIfNeeded();
                    keymap.removeShortcut(actionId, shortcut);
                    if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                        keymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
                    }
                    KeymapPanel.this.repaintLists();
                    KeymapPanel.this.currentKeymapChanged();
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group.addAction((AnAction)new DumbAwareAction("Remove Abbreviation '" + abbreviation + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                });
            }
        }
        group.add((AnAction)new Separator());
        group.add((AnAction)new DumbAwareAction("Reset Shortcuts"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ((KeymapImpl)KeymapPanel.this.createKeymapCopyIfNeeded()).clearOwnActionsId(actionId);
                KeymapPanel.this.currentKeymapChanged();
                KeymapPanel.this.repaintLists();
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setVisible(((KeymapImpl)((Object)KeymapPanel.this.myEditor.getModel().getSelected())).hasOwnActionId(actionId));
            }
        });
        return group;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog((Component)parent, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }
}

