/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class KeyboardShortcutDialog
extends ShortcutDialog<KeyboardShortcut> {
    private final JComponent myPreferredFocusedComponent;

    KeyboardShortcutDialog(Component parent) {
        super(parent, "keyboard.shortcut.dialog.title", new KeyboardShortcutPanel(new BorderLayout()));
        KeyboardShortcutPanel panel = (KeyboardShortcutPanel)this.myShortcutPanel;
        this.myPreferredFocusedComponent = panel.myFirstStroke;
        JPanel inner = new JPanel(new BorderLayout());
        inner.add("Center", panel.mySecondStroke);
        inner.add("West", panel.mySecondStrokeEnable);
        inner.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
        panel.add("North", panel.myFirstStroke);
        panel.add("South", inner);
        panel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        panel.mySecondStrokeEnable.setText(KeyMapBundle.message((String)"dialog.enable.second.stroke.checkbox", (Object[])new Object[0]));
        this.init();
    }

    protected String getHelpId() {
        return "preferences.keymap.shortcut";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    @Override
    KeyboardShortcut toShortcut(Object value) {
        return value instanceof KeyboardShortcut ? (KeyboardShortcut)value : null;
    }

    @Override
    Collection<String> getConflicts(KeyboardShortcut shortcut, String actionId, Keymap keymap) {
        return keymap.getConflicts(actionId, shortcut).keySet();
    }
}

