/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(value="keymap.xml", roamingType=RoamingType.PER_OS)}, additionalExportFile="keymaps")
public class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element>,
ApplicationComponent {
    static final String KEYMAPS_DIR_PATH = "keymaps";
    private final List<KeymapManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<String, String> myBoundShortcuts = new HashMap<String, String>();
    @NonNls
    private static final String ACTIVE_KEYMAP = "active_keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final SchemesManager<Keymap, KeymapImpl> mySchemesManager;
    public static boolean ourKeymapManagerInitialized = false;

    KeymapManagerImpl(@NotNull DefaultKeymap defaultKeymap, @NotNull SchemesManagerFactory factory) {
        SchemeProcessor<KeymapImpl> schemeProcessor = new SchemeProcessor<KeymapImpl>(){

            @NotNull
            public KeymapImpl readScheme(@NotNull Element element) throws InvalidDataException {
                KeymapImpl keymap = new KeymapImpl();
                keymap.readExternal(element, KeymapManagerImpl.this.getAllIncludingDefaultsKeymaps());
                return keymap;
            }

            public Element writeScheme(@NotNull KeymapImpl scheme) {
                return scheme.writeExternal();
            }

            @NotNull
            public SchemeProcessor.State getState(@NotNull KeymapImpl scheme) {
                return scheme.canModify() ? SchemeProcessor.State.POSSIBLY_CHANGED : SchemeProcessor.State.NON_PERSISTENT;
            }

            public void onCurrentSchemeChanged(@Nullable Scheme oldScheme) {
                Keymap keymap = (Keymap)KeymapManagerImpl.this.mySchemesManager.getCurrentScheme();
                for (KeymapManagerListener listener2 : KeymapManagerImpl.this.myListeners) {
                    listener2.activeKeymapChanged(keymap);
                }
            }
        };
        this.mySchemesManager = factory.create(KEYMAPS_DIR_PATH, (SchemeProcessor)schemeProcessor);
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() != null ? WelcomeWizardUtil.getWizardMacKeymap() : defaultKeymap.getDefaultKeymapName();
        for (Keymap keymap : defaultKeymap.getKeymaps()) {
            this.mySchemesManager.addScheme((Scheme)keymap);
            if (!keymap.getName().equals(systemDefaultKeymap)) continue;
            this.setActiveKeymap(keymap);
        }
        this.mySchemesManager.loadSchemes();
        int modifierKeyCode = KeymapManagerImpl.getMultiCaretActionModifier();
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorRightWithSelection", modifierKeyCode, 39);
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
        ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
        ourKeymapManagerInitialized = true;
    }

    public static int getMultiCaretActionModifier() {
        return SystemInfo.isMac ? 18 : 17;
    }

    @Override
    public Keymap[] getAllKeymaps() {
        List<Keymap> keymaps = this.getKeymaps((Condition<Keymap>)Conditions.alwaysTrue());
        return keymaps.toArray(new Keymap[keymaps.size()]);
    }

    @NotNull
    public List<Keymap> getKeymaps(@NotNull Condition<Keymap> additionalFilter) {
        ArrayList<Keymap> result = new ArrayList<Keymap>();
        for (Keymap keymap : this.mySchemesManager.getAllSchemes()) {
            if (keymap.getPresentableName().startsWith("$") || !additionalFilter.value((Object)keymap)) continue;
            result.add(keymap);
        }
        return result;
    }

    public Keymap[] getAllIncludingDefaultsKeymaps() {
        List keymaps = this.mySchemesManager.getAllSchemes();
        return keymaps.toArray(new Keymap[keymaps.size()]);
    }

    @Nullable
    public Keymap getKeymap(@NotNull String name) {
        return (Keymap)this.mySchemesManager.findSchemeByName(name);
    }

    public Keymap getActiveKeymap() {
        return (Keymap)this.mySchemesManager.getCurrentScheme();
    }

    @Override
    public void setActiveKeymap(@Nullable Keymap keymap) {
        this.mySchemesManager.setCurrent((Scheme)keymap);
    }

    @Override
    public void bindShortcuts(String sourceActionId, String targetActionId) {
        this.myBoundShortcuts.put(targetActionId, sourceActionId);
    }

    @Override
    public void unbindShortcuts(String targetActionId) {
        this.myBoundShortcuts.remove(targetActionId);
    }

    @Override
    public Set<String> getBoundActions() {
        return this.myBoundShortcuts.keySet();
    }

    @Override
    public String getActionBinding(String actionId) {
        String next;
        HashSet visited = null;
        String id = actionId;
        while ((next = this.myBoundShortcuts.get(id)) != null) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (visited.add(id = next)) continue;
        }
        return Comparing.equal((String)id, (String)actionId) ? null : id;
    }

    @Override
    public SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    public void setKeymaps(@NotNull List<Keymap> keymaps, @Nullable Keymap active, @Nullable Condition<Keymap> removeCondition) {
        this.mySchemesManager.setSchemes(keymaps, (Scheme)active, removeCondition);
    }

    public Element getState() {
        Element result = new Element("component");
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element e = new Element(ACTIVE_KEYMAP);
            Keymap currentScheme = (Keymap)this.mySchemesManager.getCurrentScheme();
            if (currentScheme != null) {
                e.setAttribute(NAME_ATTRIBUTE, currentScheme.getName());
            }
            result.addContent(e);
        }
        return result;
    }

    public void loadState(@NotNull Element state) {
        String activeKeymapName;
        Element child = state.getChild(ACTIVE_KEYMAP);
        String string = activeKeymapName = child == null ? null : child.getAttributeValue(NAME_ATTRIBUTE);
        if (!StringUtil.isEmptyOrSpaces((String)activeKeymapName)) {
            this.mySchemesManager.setCurrentSchemeName(activeKeymapName);
        }
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        this.pollQueue();
        this.myListeners.add(listener2);
    }

    public void addKeymapManagerListener(final @NotNull KeymapManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.pollQueue();
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                KeymapManagerImpl.this.removeKeymapManagerListener(listener2);
            }
        });
    }

    private void pollQueue() {
        for (KeymapManagerListener listener2 : this.myListeners) {
            if (!(listener2 instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener2).isDead()) continue;
            this.myListeners.remove(listener2);
        }
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        this.pollQueue();
        this.myListeners.remove(listener2);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener2) {
        this.addKeymapManagerListener(new WeakKeymapManagerListener(this, listener2));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        for (KeymapManagerListener listener2 : this.myListeners) {
            if (!(listener2 instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener2).isWrapped(listenerToRemove)) continue;
            this.myListeners.remove(listener2);
        }
    }

    @NotNull
    public String getComponentName() {
        return "KeymapManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

