/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class IgnoredFileCache {
    private final ConcurrentBitSet myCheckedIds = new ConcurrentBitSet();
    private final ConcurrentIntObjectMap<Object> myIgnoredIds = ContainerUtil.createConcurrentIntObjectMap();
    private final IgnoredPatternSet myIgnoredPatterns;
    private volatile int myVfsEventNesting = 0;

    IgnoredFileCache(@NotNull IgnoredPatternSet ignoredPatterns) {
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                IgnoredFileCache.this.myVfsEventNesting++;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                this.clearCacheForChangedFiles(events);
                IgnoredFileCache.this.myVfsEventNesting--;
            }

            private void clearCacheForChangedFiles(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    int id;
                    VirtualFile file2 = vFileEvent.getFile();
                    if (!(file2 instanceof NewVirtualFile) || !(vFileEvent instanceof VFilePropertyChangeEvent) || (id = ((NewVirtualFile)file2).getId()) < 0) continue;
                    IgnoredFileCache.this.myCheckedIds.clear(id);
                    IgnoredFileCache.this.myIgnoredIds.remove(id);
                }
            }
        });
    }

    void clearCache() {
        this.myCheckedIds.clear();
        this.myIgnoredIds.clear();
    }

    boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (this.myVfsEventNesting != 0 || !(file2 instanceof NewVirtualFile)) {
            return this.isFileIgnoredNoCache(file2);
        }
        int id = ((NewVirtualFile)file2).getId();
        if (id < 0) {
            return this.isFileIgnoredNoCache(file2);
        }
        ConcurrentBitSet checkedIds = this.myCheckedIds;
        if (checkedIds.get(id)) {
            return this.myIgnoredIds.containsKey(id);
        }
        boolean result = this.isFileIgnoredNoCache(file2);
        if (result) {
            this.myIgnoredIds.put(id, (Object)Boolean.TRUE);
        } else {
            this.myIgnoredIds.remove(id);
        }
        checkedIds.set(id);
        return result;
    }

    private boolean isFileIgnoredNoCache(@NotNull VirtualFile file2) {
        return this.myIgnoredPatterns.isIgnored(file2.getName());
    }
}

