/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    protected final Project myProject;
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final TextEditorComponent myComponent;
    private final TextEditorProvider myProvider;

    TextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, TextEditorProvider provider) {
        this.myProject = project2;
        this.myProvider = provider;
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComponent = this.createEditorComponent(project2, file2);
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(Project project2, VirtualFile file2) {
        return new TextEditorComponent(project2, file2, this);
    }

    public void dispose() {
        this.myComponent.dispose();
    }

    @NotNull
    public TextEditorComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getActiveEditor().getContentComponent();
    }

    @NotNull
    public Editor getEditor() {
        return this.getActiveEditor();
    }

    @NotNull
    private Editor getActiveEditor() {
        return this.myComponent.getEditor();
    }

    @NotNull
    public String getName() {
        return "Text";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return this.myProvider.getStateImpl(this.myProject, this.getActiveEditor(), level);
    }

    public void setState(@NotNull FileEditorState state) {
        this.myProvider.setStateImpl(this.myProject, this.getActiveEditor(), (TextEditorState)state);
    }

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public boolean isValid() {
        return this.myComponent.isEditorValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
    }

    public void updateModifiedProperty() {
        this.myComponent.updateModifiedProperty();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    public StructureViewBuilder getStructureViewBuilder() {
        Document document = this.myComponent.getEditor().getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() != -1 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        ((OpenFileDescriptor)navigatable).navigateIn(this.getEditor());
    }

    public String toString() {
        return "Editor: " + this.getComponent().getFile();
    }
}

