/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextEditorComponent
extends JBLoadingPanel
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.TextEditorComponent");
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    private final TextEditorImpl myTextEditor;
    private final Document myDocument;
    private final MyDocumentListener myDocumentListener;
    private final MyVirtualFileListener myVirtualFileListener;
    @NotNull
    private final Editor myEditor;
    private boolean myModified;
    private boolean myValid;
    private final MessageBusConnection myConnection;

    TextEditorComponent(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorImpl textEditor) {
        super((LayoutManager)new BorderLayout(), (Disposable)textEditor);
        this.myProject = project2;
        this.myFile = file2;
        this.myTextEditor = textEditor;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        this.myEditor = this.createEditor();
        this.add(this.myEditor.getComponent(), "Center");
        this.myModified = this.isModifiedImpl();
        this.myValid = this.isEditorValidImpl();
        LOG.assertTrue(this.myValid);
        this.myVirtualFileListener = new MyVirtualFileListener();
        this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
        this.myConnection = project2.getMessageBus().connect();
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                TextEditorComponent.this.updateHighlighters();
            }

            public void exitDumbMode() {
                TextEditorComponent.this.updateHighlighters();
            }
        });
    }

    void dispose() {
        this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
        if (!this.myProject.isDefault()) {
            EditorHistoryManager.getInstance(this.myProject).updateHistoryEntry(this.myFile, false);
        }
        this.disposeEditor();
        this.myConnection.disconnect();
        this.myFile.getFileSystem().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
    }

    void selectNotify() {
        this.updateStatusBar();
    }

    private static void assertThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @NotNull
    Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    private Editor createEditor() {
        Editor editor = EditorFactory.getInstance().createEditor(this.myDocument, this.myProject);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        ((EditorEx)editor).getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, EditorColorsManager.getInstance().getGlobalScheme(), this.myProject);
        ((EditorEx)editor).setHighlighter(highlighter);
        ((EditorEx)editor).setFile(this.myFile);
        ((EditorEx)editor).setContextMenuGroupId("EditorPopupMenu");
        ((EditorImpl)editor).setDropHandler(new FileDropHandler(editor));
        TextEditorProvider.putTextEditor(editor, this.myTextEditor);
        return editor;
    }

    private void disposeEditor() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    boolean isModified() {
        TextEditorComponent.assertThread();
        return this.myModified;
    }

    private boolean isModifiedImpl() {
        return FileDocumentManager.getInstance().isFileModified(this.myFile);
    }

    void updateModifiedProperty() {
        Boolean oldModified = this.myModified;
        this.myModified = this.isModifiedImpl();
        this.myTextEditor.firePropertyChange("modified", oldModified, this.myModified);
    }

    boolean isEditorValid() {
        return this.myValid && !this.myEditor.isDisposed();
    }

    private boolean isEditorValidImpl() {
        return FileDocumentManager.getInstance().getDocument(this.myFile) != null;
    }

    private void updateValidProperty() {
        Boolean oldValid = this.myValid;
        this.myValid = this.isEditorValidImpl();
        this.myTextEditor.firePropertyChange("valid", oldValid, this.myValid);
    }

    private void updateHighlighters() {
        if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile);
            ((EditorEx)this.myEditor).setHighlighter(highlighter);
        }
    }

    private void updateStatusBar() {
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            return;
        }
        statusBar.updateWidgets();
    }

    @Nullable
    private Editor validateCurrentEditor() {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return this.myEditor;
    }

    public Object getData(String dataId) {
        Object o;
        Editor e = this.validateCurrentEditor();
        if (e == null || e.isDisposed()) {
            return null;
        }
        if (!this.myProject.isDisposed() && !this.myProject.isDefault() && (o = FileEditorManager.getInstance((Project)this.myProject).getData(dataId, e, e.getCaretModel().getCurrentCaret())) != null) {
            return o;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return e;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile.isValid() ? this.myFile : null;
        }
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    private final class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            if ("name".equals(e.getPropertyName())) {
                TextEditorComponent.this.updateValidProperty();
                if (Comparing.equal((Object)e.getFile(), (Object)TextEditorComponent.this.myFile) && ("FileContentUtilCore.saveOrReload".equals(e.getRequestor()) || !Comparing.equal((Object)e.getOldValue(), (Object)e.getNewValue()))) {
                    TextEditorComponent.this.updateHighlighters();
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event.isFromSave()) {
                TextEditorComponent.assertThread();
                VirtualFile file2 = event.getFile();
                LOG.assertTrue(file2.isValid());
                if (TextEditorComponent.this.myFile.equals(file2)) {
                    TextEditorComponent.this.updateModifiedProperty();
                }
            }
        }
    }

    private final class MyFileTypeListener
    extends FileTypeListener.Adapter {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            TextEditorComponent.assertThread();
            TextEditorComponent.this.updateValidProperty();
            TextEditorComponent.this.updateHighlighters();
        }
    }

    private final class MyDocumentListener
    extends DocumentAdapter {
        private final Runnable myUpdateRunnable;

        public MyDocumentListener() {
            this.myUpdateRunnable = new Runnable(){

                @Override
                public void run() {
                    TextEditorComponent.this.updateModifiedProperty();
                }
            };
        }

        public void documentChanged(DocumentEvent e) {
            ApplicationManager.getApplication().invokeLater(this.myUpdateRunnable);
        }
    }
}

