/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.http.RefreshRemoteFileAction;
import com.intellij.openapi.fileEditor.impl.http.RemoteFileEditorActionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.ui.AppUIUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel");
    @NonNls
    private static final String ERROR_CARD = "error";
    @NonNls
    private static final String DOWNLOADING_CARD = "downloading";
    @NonNls
    private static final String EDITOR_CARD = "editor";
    private JPanel myMainPanel;
    private JLabel myProgressLabel;
    private JProgressBar myProgressBar;
    private JButton myCancelButton;
    private JPanel myContentPanel;
    private JLabel myErrorLabel;
    private JButton myTryAgainButton;
    private JButton myChangeProxySettingsButton;
    private JPanel myEditorPanel;
    private JTextField myUrlTextField;
    private JPanel myToolbarPanel;
    private final Project myProject;
    private final HttpVirtualFile myVirtualFile;
    private final MergingUpdateQueue myProgressUpdatesQueue;
    private final MyDownloadingListener myDownloadingListener;
    private final PropertyChangeListener myPropertyChangeListener;
    @Nullable
    private TextEditor myFileEditor;

    public RemoteFilePanel(Project project2, HttpVirtualFile virtualFile, @NotNull PropertyChangeListener propertyChangeListener) {
        this.myProject = project2;
        this.myVirtualFile = virtualFile;
        this.myPropertyChangeListener = propertyChangeListener;
        this.$$$setupUI$$$();
        this.myErrorLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
        this.myUrlTextField.setText(virtualFile.getUrl());
        this.myProgressUpdatesQueue = new MergingUpdateQueue("downloading progress updates", 300, false, (JComponent)this.myMainPanel);
        this.initToolbar(project2);
        final RemoteFileInfo remoteFileInfo = virtualFile.getFileInfo();
        this.myDownloadingListener = new MyDownloadingListener();
        assert (remoteFileInfo != null);
        remoteFileInfo.addDownloadingListener(this.myDownloadingListener);
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                remoteFileInfo.cancelDownloading();
            }
        });
        this.myTryAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                RemoteFilePanel.this.showCard(RemoteFilePanel.DOWNLOADING_CARD);
                remoteFileInfo.restartDownloading();
            }
        });
        this.myChangeProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                HttpConfigurable.editConfigurable((JComponent)RemoteFilePanel.this.myMainPanel);
            }
        });
        if (remoteFileInfo.getState() != RemoteFileState.DOWNLOADED) {
            this.showCard(DOWNLOADING_CARD);
            remoteFileInfo.startDownloading();
        }
        if (remoteFileInfo.getState() == RemoteFileState.DOWNLOADED) {
            this.switchEditor();
        } else {
            String errorMessage = remoteFileInfo.getErrorMessage();
            if (errorMessage != null) {
                this.myDownloadingListener.errorOccurred(errorMessage);
            }
        }
    }

    private void initToolbar(Project project2) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RefreshRemoteFileAction(this.myVirtualFile));
        for (RemoteFileEditorActionProvider actionProvider : (RemoteFileEditorActionProvider[])RemoteFileEditorActionProvider.EP_NAME.getExtensions()) {
            group.addAll(actionProvider.createToolbarActions(project2, this.myVirtualFile));
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        this.myToolbarPanel.add((Component)actionToolbar.getComponent(), "Center");
    }

    private void showCard(String name) {
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, name);
    }

    private void switchEditor() {
        LOG.debug("Switching editor...");
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(RemoteFilePanel.this.myProject, RemoteFilePanel.this.myVirtualFile);
                textEditor.addPropertyChangeListener(RemoteFilePanel.this.myPropertyChangeListener);
                RemoteFilePanel.this.myEditorPanel.removeAll();
                RemoteFilePanel.this.myEditorPanel.add((Component)textEditor.getComponent(), "Center");
                RemoteFilePanel.this.myFileEditor = textEditor;
                RemoteFilePanel.this.showCard(RemoteFilePanel.EDITOR_CARD);
                LOG.debug("Editor for downloaded file opened.");
            }
        }, this.myProject.getDisposed());
    }

    @Nullable
    public TextEditor getFileEditor() {
        return this.myFileEditor;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteFilePanel.this.myProgressUpdatesQueue.showNotify();
                if (RemoteFilePanel.this.myFileEditor != null) {
                    RemoteFilePanel.this.myFileEditor.selectNotify();
                }
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteFilePanel.this.myProgressUpdatesQueue.hideNotify();
                if (RemoteFilePanel.this.myFileEditor != null) {
                    RemoteFilePanel.this.myFileEditor.deselectNotify();
                }
            }
        });
    }

    public void dispose() {
        this.myVirtualFile.getFileInfo().removeDownloadingListener(this.myDownloadingListener);
        this.myProgressUpdatesQueue.dispose();
        if (this.myFileEditor != null) {
            Disposer.dispose((Disposable)this.myFileEditor);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JButton jButton3;
        JProgressBar jProgressBar;
        JLabel jLabel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, DOWNLOADING_CARD);
        this.myProgressLabel = jLabel2 = new JLabel();
        jLabel2.setText("Downloading started");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(241, 28), null, 1));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel6.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCancelButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
        jPanel6.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, ERROR_CARD);
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myChangeProxySettingsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/UIBundle").getString("downloading.file.change.http.proxy.settings"));
        jPanel8.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTryAgainButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/UIBundle").getString("downloading.file.try.again.button"));
        jPanel8.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, EDITOR_CARD);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(3, 3, 0, 3), 0, -1, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 1, null, null, null));
        this.myUrlTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel9.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDownloadingListener
    implements FileDownloadingListener {
        private MyDownloadingListener() {
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFilePanel.this.switchEditor();
        }

        @Override
        public void downloadingCancelled() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RemoteFilePanel.this.myFileEditor != null) {
                        RemoteFilePanel.this.showCard(RemoteFilePanel.EDITOR_CARD);
                    } else {
                        RemoteFilePanel.this.myErrorLabel.setText("Downloading cancelled");
                        RemoteFilePanel.this.showCard(RemoteFilePanel.ERROR_CARD);
                    }
                }
            });
        }

        @Override
        public void downloadingStarted() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteFilePanel.this.showCard(RemoteFilePanel.DOWNLOADING_CARD);
                }
            });
        }

        @Override
        public void errorOccurred(final @NotNull String errorMessage) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteFilePanel.this.myErrorLabel.setText(errorMessage);
                    RemoteFilePanel.this.showCard(RemoteFilePanel.ERROR_CARD);
                }
            });
        }

        @Override
        public void progressMessageChanged(boolean indeterminate, final @NotNull String message) {
            RemoteFilePanel.this.myProgressUpdatesQueue.queue(new Update("progress text"){

                public void run() {
                    RemoteFilePanel.this.myProgressLabel.setText(message);
                }
            });
        }

        @Override
        public void progressFractionChanged(final double fraction) {
            RemoteFilePanel.this.myProgressUpdatesQueue.queue(new Update("fraction"){

                public void run() {
                    RemoteFilePanel.this.myProgressBar.setValue((int)Math.round(100.0 * fraction));
                }
            });
        }
    }
}

