/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpFileEditor
extends BaseRemoteFileEditor {
    private final RemoteFilePanel myPanel;

    public HttpFileEditor(@NotNull Project project2, @NotNull HttpVirtualFile virtualFile) {
        super(project2);
        this.myPanel = new RemoteFilePanel(project2, virtualFile, this);
        RemoteFileInfo fileInfo = virtualFile.getFileInfo();
        assert (fileInfo != null);
        fileInfo.download().done((Consumer)new Consumer<VirtualFile>(){

            public void consume(VirtualFile file2) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HttpFileEditor.this.contentLoaded();
                    }
                }, HttpFileEditor.this.myProject.getDisposed());
            }
        }).rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable throwable) {
                HttpFileEditor.this.contentRejected();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel.getMainPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getPreferredFocusedComponent();
        }
        return this.myPanel.getMainPanel();
    }

    @NotNull
    public String getName() {
        return "Http";
    }

    public void selectNotify() {
        this.myPanel.selectNotify();
    }

    public void deselectNotify() {
        this.myPanel.deselectNotify();
    }

    @Override
    @Nullable
    protected TextEditor getTextEditor() {
        return this.myPanel.getFileEditor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPanel.dispose();
    }
}

