/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.test.TestEditorManagerImpl");
    private final Project myProject;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor = new HashMap();
    private VirtualFile myActiveFile;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    public TestEditorManagerImpl(@NotNull Project project2) {
        this.myProject = project2;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        project2.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectClosed(Project project2) {
                if (project2 == TestEditorManagerImpl.this.myProject) {
                    TestEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(final @NotNull VirtualFile file2, final boolean focusEditor, boolean searchForSplitter) {
        final Ref result = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                result.set((Object)TestEditorManagerImpl.this.openFileImpl3(file2, focusEditor));
            }
        }, "", null);
        return (Pair)result.get();
    }

    private Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(VirtualFile file2, boolean focusEditor) {
        FileEditorProvider provider = (FileEditorProvider)file2.getUserData(FileEditorProvider.KEY);
        if (provider != null && provider.accept(this.getProject(), file2)) {
            return Pair.create((Object)new FileEditor[]{provider.createEditor(this.getProject(), file2)}, (Object)new FileEditorProvider[]{provider});
        }
        Editor editor = this.openTextEditor(new OpenFileDescriptor(this.myProject, file2), focusEditor);
        assert (editor != null);
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        return Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{TestEditorManagerImpl.getProvider()});
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        return this.openFileWithProviders(file2, focusEditor, false);
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable2) {
        runnable2.run();
        return ActionCallback.DONE;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public void flipTabs() {
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
    }

    @Override
    public void closeAllFiles() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Iterator<Editor> it = this.myVirtualFile2Editor.values().iterator();
        while (it.hasNext()) {
            Editor editor = it.next();
            it.remove();
            if (editor == null || editor.isDisposed()) continue;
            editorFactory.releaseEditor(editor);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor) {
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project2, @NotNull VirtualFile file2) {
                throw new IncorrectOperationException();
            }

            public void writeState(@NotNull FileEditorState state, @NotNull Project project2, @NotNull Element targetElement) {
            }

            @NotNull
            public String getEditorTypeId() {
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        return AsyncResult.done(null);
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        return new EditorWindow[0];
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Editor editor = this.getEditor(file2);
        return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        return this.getEditor(file2) != null;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        FileEditor e = this.getSelectedEditor(file2);
        if (e == null) {
            return new FileEditor[0];
        }
        return new FileEditor[]{e};
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        return this.getEditors(file2);
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.closeAllFiles();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Editor editor = this.myVirtualFile2Editor.remove(file2);
        if (editor != null) {
            TextEditorProvider editorProvider = TextEditorProvider.getInstance();
            editorProvider.disposeEditor((FileEditor)editorProvider.getTextEditor(editor));
            EditorFactory.getInstance().releaseEditor(editor);
        }
        if (Comparing.equal((Object)file2, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        this.closeFile(file2);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        return new FileEditor[0];
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        return VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
    }

    public Editor getEditor(VirtualFile file2) {
        return this.myVirtualFile2Editor.get(file2);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditor[] result = new FileEditor[this.myVirtualFile2Editor.size()];
        int i = 0;
        for (Map.Entry<VirtualFile, Editor> entry : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry.getValue());
            result[i++] = textEditor;
        }
        return result;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        VirtualFile file2 = descriptor.getFile();
        Editor editor = this.myVirtualFile2Editor.get(file2);
        if (editor == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            LOG.assertTrue(psiFile != null, (Object)file2);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null, (Object)psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file2);
            ((EditorEx)editor).setHighlighter(highlighter);
            ((EditorEx)editor).setFile(file2);
            this.myVirtualFile2Editor.put(file2, editor);
        }
        if (descriptor.getOffset() >= 0) {
            editor.getCaretModel().moveToOffset(descriptor.getOffset());
        } else if (descriptor.getLine() >= 0 && descriptor.getColumn() >= 0) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(descriptor.getLine(), descriptor.getColumn()));
        }
        editor.getSelectionModel().removeSelection();
        this.myActiveFile = file2;
        return editor;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        return Collections.emptyList();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        return Pair.create((Object)new FileEditor[0], (Object)new FileEditorProvider[0]);
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        return ActionCallback.DONE;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
    }
}

