/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooserUtil {
    private static final String LAST_OPENED_FILE_PATH = "last_opened_file_path";

    @Nullable
    public static VirtualFile getLastOpenedFile(@Nullable Project project2) {
        if (project2 != null) {
            VirtualFile lastOpenedFile;
            String path = PropertiesComponent.getInstance((Project)project2).getValue(LAST_OPENED_FILE_PATH);
            if (path == null) {
                path = PropertiesComponent.getInstance().getValue(LAST_OPENED_FILE_PATH);
                if (path == null) {
                    return null;
                }
                lastOpenedFile = LocalFileSystem.getInstance().findFileByPath(path);
                FileChooserUtil.setLastOpenedFile(project2, lastOpenedFile);
            } else {
                lastOpenedFile = LocalFileSystem.getInstance().findFileByPath(path);
            }
            return lastOpenedFile;
        }
        return null;
    }

    public static void setLastOpenedFile(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 != null && !project2.isDisposed() && file2 != null) {
            PropertiesComponent.getInstance((Project)project2).setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        }
    }

    @Nullable
    public static VirtualFile getFileToSelect(@NotNull FileChooserDescriptor descriptor, @Nullable Project project2, @Nullable VirtualFile toSelect, @Nullable VirtualFile lastPath) {
        boolean chooseDir = descriptor instanceof FileSaverDescriptor;
        VirtualFile result = toSelect == null && lastPath == null ? (project2 == null ? null : project2.getBaseDir()) : (toSelect != null && lastPath != null ? (Boolean.TRUE.equals(descriptor.getUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT)) ? lastPath : toSelect) : (toSelect == null ? lastPath : toSelect));
        if (result != null) {
            if (chooseDir && !result.isDirectory()) {
                result = result.getParent();
            }
        } else if (SystemInfo.isUnix) {
            result = VfsUtil.getUserHomeDir();
        }
        return result;
    }

    @NotNull
    public static List<VirtualFile> getChosenFiles(final @NotNull FileChooserDescriptor descriptor, @NotNull List<VirtualFile> selectedFiles) {
        return ContainerUtil.mapNotNull(selectedFiles, (Function)new NullableFunction<VirtualFile, VirtualFile>(){

            public VirtualFile fun(VirtualFile file2) {
                return file2 != null && file2.isValid() ? descriptor.getFileToSelect(file2) : null;
            }
        });
    }
}

