/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UIBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSaverDialogImpl
extends FileChooserDialogImpl
implements FileSaverDialog {
    protected final JTextField myFileName = new JTextField(20);
    protected final JComboBox myExtensions = new JComboBox();
    protected final FileSaverDescriptor myDescriptor;

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor, @NotNull Component parent) {
        super((FileChooserDescriptor)descriptor, parent);
        this.myDescriptor = descriptor;
        for (String ext : descriptor.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor));
    }

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor, @Nullable Project project2) {
        super((FileChooserDescriptor)descriptor, project2);
        this.myDescriptor = descriptor;
        for (String ext : descriptor.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor));
    }

    private static String getChooserTitle(FileSaverDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.save.dialog.default.title", (Object[])new Object[0]);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        this.init();
        this.restoreSelection(baseDir);
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(List<VirtualFile> selection) {
                FileSaverDialogImpl.this.updateFileName(selection);
                FileSaverDialogImpl.this.updateOkButton();
            }
        }, this.myDisposable);
        if (filename != null) {
            this.myFileName.setText(filename);
        }
        this.show();
        if (this.getExitCode() == 0) {
            File file2 = this.getFile();
            return file2 == null ? null : new VirtualFileWrapper(file2);
        }
        return null;
    }

    @Nullable
    protected File getFile() {
        VirtualFile selected = this.myFileSystemTree.getSelectedFile();
        if (selected != null && !selected.isDirectory()) {
            return new File(selected.getPath());
        }
        String path = selected == null ? this.myPathTextField.getTextFieldText() : selected.getPath();
        File dir = new File(path);
        if (!dir.exists()) {
            return null;
        }
        if (dir.isDirectory()) {
            path = path + File.separator + this.myFileName.getText();
        }
        boolean correctExt = true;
        for (String ext : this.myDescriptor.getFileExtensions()) {
            correctExt = path.endsWith("." + ext);
            if (correctExt) break;
        }
        if (!correctExt) {
            path = path + "." + this.myExtensions.getSelectedItem();
        }
        return new File(path);
    }

    private void updateFileName(List<VirtualFile> selection) {
        for (VirtualFile file2 : selection) {
            if (file2.isDirectory()) {
                this.myPathTextField.getField().setText(file2.getPath());
                continue;
            }
            this.myFileName.setText(file2.getName());
            VirtualFile parent = file2.getParent();
            if (parent == null) continue;
            this.myPathTextField.getField().setText(parent.getPath());
        }
        this.updateOkButton();
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent component = super.createCenterPanel();
        FileChooserDialogImpl.MyPanel panel = new FileChooserDialogImpl.MyPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)component, "Center");
        panel.add((Component)this.createFileNamePanel(), "South");
        return panel;
    }

    protected JComponent createFileNamePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(UIBundle.message((String)"file.chooser.save.dialog.file.name", (Object[])new Object[0])), "West");
        this.myFileName.setText("");
        this.myFileName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FileSaverDialogImpl.this.updateOkButton();
            }
        });
        panel.add((Component)this.myFileName, "Center");
        if (this.myExtensions.getModel().getSize() > 0) {
            this.myExtensions.setSelectedIndex(0);
            panel.add((Component)this.myExtensions, "East");
        }
        return panel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myFileName;
    }

    private boolean isFileNameExist() {
        if (this.myPathTextField == null) {
            return false;
        }
        String path = this.myPathTextField.getTextFieldText();
        return path != null && new File(path.trim()).exists() && this.myFileName.getText().trim().length() > 0;
    }

    protected void updateOkButton() {
        this.setOKActionEnabled(true);
    }

    protected void setOKActionEnabled(boolean isEnabled) {
        super.setOKActionEnabled(this.isFileNameExist());
    }

    @Override
    protected void doOKAction() {
        File file2 = this.getFile();
        if (file2 != null && file2.exists() && 0 != Messages.showYesNoDialog((Component)this.getRootPane(), (String)UIBundle.message((String)"file.chooser.save.dialog.confirmation", (Object[])new Object[]{file2.getName()}), (String)UIBundle.message((String)"file.chooser.save.dialog.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) {
            return;
        }
        this.storeSelection(this.myFileSystemTree.getSelectedFile());
        super.doOKAction();
    }
}

