/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.file.exclude.ProjectPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EnforcedPlainTextFileTypeManager
implements ProjectManagerListener {
    private final Map<Project, Collection<VirtualFile>> myPlainTextFileSets = ContainerUtil.createConcurrentWeakMap();
    private volatile boolean mySetsInitialized;
    private static final Object LOCK = new Object();

    public EnforcedPlainTextFileTypeManager() {
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedAsPlainText(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (!this.mySetsInitialized) {
            Iterator<Collection<VirtualFile>> iterator = LOCK;
            synchronized (iterator) {
                if (!this.mySetsInitialized) {
                    this.initPlainTextFileSets();
                    this.mySetsInitialized = true;
                }
            }
        }
        if (!this.myPlainTextFileSets.isEmpty()) {
            for (Collection<VirtualFile> projectSet : this.myPlainTextFileSets.values()) {
                if (projectSet == null || !projectSet.contains(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private void initPlainTextFileSets() {
        Project[] openProjects;
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            this.addProjectPlainTextFiles(openProject);
        }
    }

    public static boolean isApplicableFor(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        FileType originalType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        return !originalType.isBinary() && originalType != FileTypes.PLAIN_TEXT && originalType != StdFileTypes.JAVA;
    }

    public void markAsPlainText(@NotNull Project project2, VirtualFile ... files) {
        this.setPlainTextStatus(project2, true, files);
    }

    public void resetOriginalFileType(@NotNull Project project2, VirtualFile ... files) {
        this.setPlainTextStatus(project2, false, files);
    }

    private void setPlainTextStatus(final @NotNull Project project2, final boolean isAdded, final VirtualFile ... files) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project2);
                for (VirtualFile file2 : files) {
                    if (!projectPlainTextFileTypeManager.hasProjectContaining(file2)) continue;
                    EnforcedPlainTextFileTypeManager.this.ensureProjectFileSetAdded(project2, projectPlainTextFileTypeManager);
                    if (!(isAdded ? projectPlainTextFileTypeManager.addFile(file2) : projectPlainTextFileTypeManager.removeFile(file2))) continue;
                    FileBasedIndex.getInstance().requestReindex(file2);
                }
                FileContentUtilCore.reparseFiles((VirtualFile[])files);
            }
        });
    }

    private void ensureProjectFileSetAdded(@NotNull Project project2, @NotNull ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager) {
        if (!this.myPlainTextFileSets.containsKey(project2)) {
            this.myPlainTextFileSets.put(project2, projectPlainTextFileTypeManager.getFiles());
        }
    }

    public static EnforcedPlainTextFileTypeManager getInstance() {
        return (EnforcedPlainTextFileTypeManager)ServiceManager.getService(EnforcedPlainTextFileTypeManager.class);
    }

    public void projectOpened(Project project2) {
        this.addProjectPlainTextFiles(project2);
    }

    public boolean canCloseProject(Project project2) {
        return true;
    }

    public void projectClosed(Project project2) {
        this.myPlainTextFileSets.remove(project2);
    }

    public void projectClosing(Project project2) {
    }

    private void addProjectPlainTextFiles(@NotNull Project project2) {
        ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager;
        if (!project2.isDisposed() && (projectPlainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project2)) != null) {
            this.myPlainTextFileSets.put(project2, projectPlainTextFileTypeManager.getFiles());
        }
    }
}

