/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=1)
public class ModuleNode
extends ExternalSystemNode<ModuleData> {
    private final boolean myIsRoot;
    private final ModuleData myData;
    private final RunConfigurationsNode myRunConfigurationsNode;

    public ModuleNode(ExternalProjectsView externalProjectsView, DataNode<ModuleData> dataNode, boolean isRoot) {
        super(externalProjectsView, null, dataNode);
        this.myIsRoot = isRoot;
        this.myData = (ModuleData)dataNode.getData();
        this.myRunConfigurationsNode = new RunConfigurationsNode(externalProjectsView, this);
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
        String hint = null;
        if (this.myIsRoot) {
            hint = "root";
        }
        String tooltip = this.myData.toString() + (this.myData.getDescription() != null ? "<br>" + this.myData.getDescription() : "");
        this.setNameAndTooltip(this.getName(), tooltip, hint);
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList myChildNodes = ContainerUtil.newArrayList();
        myChildNodes.addAll(super.doBuildChildren());
        myChildNodes.add(this.myRunConfigurationsNode);
        return myChildNodes;
    }

    public String getName() {
        return this.myData.getId();
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.ModuleMenu";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        return this.myIsRoot ? -1 : (node instanceof ModuleNode && ((ModuleNode)node).myIsRoot ? 1 : super.compareTo(node));
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations();
        this.childrenChanged();
        this.getExternalProjectsView().updateUpTo(this);
        this.getExternalProjectsView().updateUpTo(this.myRunConfigurationsNode);
    }
}

