/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkComboBox
extends ComboBoxWithWidePopup {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private Project myProject;
    private boolean suggestJre = true;

    public ExternalSystemJdkComboBox() {
        this(null);
    }

    public ExternalSystemJdkComboBox(@Nullable Project project2) {
        this.myProject = project2;
        this.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                JdkComboBoxItem item = (JdkComboBoxItem)value;
                CompositeAppearance appearance = new CompositeAppearance();
                JavaSdk sdkType = JavaSdk.getInstance();
                appearance.setIcon(sdkType.getIcon());
                SimpleTextAttributes attributes = ExternalSystemJdkComboBox.getTextAttributes(item.valid, selected);
                CompositeAppearance.DequeEnd ending = appearance.getEnding();
                ending.addText(item.label, attributes);
                if (item.comment != null && !item.comment.equals(item.jdkName)) {
                    SimpleTextAttributes textAttributes = !item.valid ? SimpleTextAttributes.ERROR_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
                    ending.addComment(item.comment, textAttributes);
                }
                CompositeAppearance compositeAppearance = ending.getAppearance();
                compositeAppearance.customize((SimpleColoredComponent)this);
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public ExternalSystemJdkComboBox withoutJre() {
        this.suggestJre = false;
        return this;
    }

    public void refreshData(@Nullable String selectedValue) {
        Map<String, JdkComboBoxItem> jdkMap = this.collectComboBoxItem();
        if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (selectedValue.length() > 0);
            jdkMap.put(selectedValue, new JdkComboBoxItem(selectedValue, selectedValue, "", false));
        }
        this.removeAllItems();
        for (Map.Entry<String, JdkComboBoxItem> entry : jdkMap.entrySet()) {
            ((DefaultComboBoxModel)this.getModel()).addElement(entry.getValue());
        }
        ExternalSystemJdkComboBox.select((DefaultComboBoxModel)this.getModel(), selectedValue);
    }

    private static void select(DefaultComboBoxModel model, Object value) {
        for (int i = 0; i < model.getSize(); ++i) {
            JdkComboBoxItem comboBoxUtil = (JdkComboBoxItem)model.getElementAt(i);
            if (!comboBoxUtil.jdkName.equals(value)) continue;
            model.setSelectedItem(comboBoxUtil);
            return;
        }
        if (model.getSize() != 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    @Nullable
    public String getSelectedValue() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object item = model.getSelectedItem();
        return item != null ? ((JdkComboBoxItem)item).jdkName : null;
    }

    private Map<String, JdkComboBoxItem> collectComboBoxItem() {
        LinkedHashMap<String, JdkComboBoxItem> result = new LinkedHashMap<String, JdkComboBoxItem>();
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
            String name = projectJdk.getName();
            String comment = ExternalSystemJdkComboBox.buildComment(projectJdk);
            result.put(name, new JdkComboBoxItem(name, name, comment, ((SdkType)projectJdk.getSdkType()).sdkHasValidPath(projectJdk)));
        }
        if (this.suggestJre) {
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            assert (internalJdk.getHomePath() != null);
            result.put("#JAVA_INTERNAL", new JdkComboBoxItem("#JAVA_INTERNAL", ExternalSystemBundle.message((String)"external.system.java.internal.jre", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(internalJdk), true));
        }
        if (this.myProject != null && !this.myProject.isDisposed()) {
            Sdk projectSdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
            result.put("#USE_PROJECT_JDK", new JdkComboBoxItem("#USE_PROJECT_JDK", "Use Project JDK", projectSdk == null ? "not defined yet" : ExternalSystemJdkComboBox.buildComment(projectSdk), projectSdk != null));
        }
        String javaHomePath = System.getenv("JAVA_HOME");
        String javaHomeLabel = ExternalSystemBundle.message((String)"external.system.java.home.env", (Object[])new Object[0]);
        result.put("#JAVA_HOME", new JdkComboBoxItem("#JAVA_HOME", javaHomeLabel, javaHomePath == null ? "not defined yet" : ExternalSystemJdkComboBox.truncateLongPath(javaHomePath), javaHomePath != null));
        return result;
    }

    private static String buildComment(@NotNull Sdk sdk) {
        String versionString = sdk.getVersionString();
        String path = sdk.getHomePath();
        StringBuilder buf = new StringBuilder();
        if (versionString != null) {
            buf.append(versionString);
        }
        if (path != null) {
            buf.append(versionString != null ? ", " : "");
            buf.append("path: ").append(ExternalSystemJdkComboBox.truncateLongPath(path));
        }
        return buf.toString();
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path.length() > 50) {
            return path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
        }
        return path;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static class JdkComboBoxItem {
        private String jdkName;
        private String label;
        private String comment;
        private boolean valid;

        public JdkComboBoxItem(String jdkName, String label, String comment, boolean valid) {
            this.jdkName = jdkName;
            this.label = label;
            this.comment = comment;
            this.valid = valid;
        }
    }
}

