/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483645)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ContentRootDataService.class.getName()));

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        return ProjectKeys.CONTENT_ROOT;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module2 = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module3 = module2 = module2 != null ? module2 : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, (Collection)entry.getValue(), module2);
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<DataNode<ContentRootData>> data, @NotNull Module module2) {
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
        for (ContentEntry contentEntry : contentEntries) {
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
        }
        boolean createEmptyContentRootDirectories = false;
        if (!data.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)data.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module2.getProject(), (ProjectSystemId)projectSystemId);
            String path = module2.getOptionValue("external.root.project.path");
            if (path != null) {
                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(path);
                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
            }
        }
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> node : data) {
            ContentRootData contentRoot = (ContentRootData)node.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                contentEntry.clearSourceFolders();
                importedContentEntries.add(contentEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module2.getName()));
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.TEST_SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaSourceRootType.TEST_SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaResourceRootType.RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module2.getName(), JavaResourceRootType.TEST_RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module2.getName(), module2.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(path)) continue;
            return entry;
        }
        return model.addContentEntry(ContentRootDataService.toVfsUrl(path));
    }

    private static void createSourceRootIfAbsent(@NotNull ContentEntry entry, final @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        SourceFolder[] folders;
        for (SourceFolder folder : folders = entry.getSourceFolders()) {
            VirtualFile file2 = folder.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(root.getPath())) continue;
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (JavaSourceRootType.SOURCE.equals(folderRootType) || sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(folderRootType) && JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
                return;
            }
            entry.removeSourceFolder(folder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        SourceFolder sourceFolder = entry.addSourceFolder(ContentRootDataService.toVfsUrl(root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories) {
            ExternalSystemApiUtil.doWriteAction((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        VfsUtil.createDirectoryIfMissing((String)root.getPath());
                    }
                    catch (IOException e) {
                        LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                    }
                }
            });
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project2) {
        String rootPath = root.getPath();
        for (VirtualFile file2 : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(rootPath)) continue;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        entry.addExcludeFolder(ContentRootDataService.toVfsUrl(rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static String toVfsUrl(@NotNull String path) {
        return "file://" + path;
    }
}

