/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
public abstract class AbstractDependencyDataService<E extends AbstractDependencyData<?>, I extends ExportableOrderEntry>
extends AbstractProjectDataService<E, I> {
    private static final Logger LOG = Logger.getInstance((String)AbstractDependencyDataService.class.getName());

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            DataNode moduleDataNode = (DataNode)entry.getKey();
            Module module2 = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            if (module2 == null) {
                LOG.warn(String.format("Can't import dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), moduleDataNode));
                continue;
            }
            Map<OrderEntry, OrderAware> moduleDependenciesOrder = this.importData((Collection)entry.getValue(), module2, modelsProvider);
            Map orderEntryDataMap = (Map)moduleDataNode.getUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY);
            if (orderEntryDataMap != null) {
                orderEntryDataMap.putAll(moduleDependenciesOrder);
                continue;
            }
            moduleDataNode.putUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY, moduleDependenciesOrder);
        }
    }

    protected abstract Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<E>> var1, @NotNull Module var2, @NotNull IdeModifiableModelsProvider var3);

    @NotNull
    public Computable<Collection<I>> computeOrphanData(final @NotNull Collection<DataNode<E>> toImport, final @NotNull ProjectData projectData, @NotNull Project project2, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        return new Computable<Collection<I>>(){

            public Collection<I> compute() {
                MultiMap byModuleName = MultiMap.create();
                for (DataNode node : toImport) {
                    AbstractDependencyData data = (AbstractDependencyData)node.getData();
                    byModuleName.putValue((Object)data.getOwnerModule().getInternalName(), (Object)AbstractDependencyDataService.getInternalName(data));
                }
                ModifiableModuleModel modifiableModuleModel = modelsProvider.getModifiableModuleModel();
                List orphanEntries = ContainerUtil.newSmartList();
                for (Module module2 : modelsProvider.getModules(projectData)) {
                    for (OrderEntry entry : modelsProvider.getOrderEntries(module2)) {
                        String moduleName;
                        if (entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getLibraryName() == null && entry.getUrls(OrderRootType.CLASSES).length == 0 || !AbstractDependencyDataService.this.getOrderEntryType().isInstance(entry) || byModuleName.get((Object)(moduleName = (String)ObjectUtils.chooseNotNull((Object)modifiableModuleModel.getNewName(entry.getOwnerModule()), (Object)entry.getOwnerModule().getName()))).contains(AbstractDependencyDataService.this.getOrderEntryName(modelsProvider, (ExportableOrderEntry)entry))) continue;
                        orphanEntries.add((ExportableOrderEntry)entry);
                    }
                }
                return orphanEntries;
            }
        };
    }

    @NotNull
    protected abstract Class<I> getOrderEntryType();

    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull I orderEntry) {
        return orderEntry.getPresentableName();
    }

    public void removeData(@NotNull Computable<Collection<I>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Map<Module, Collection<ExportableOrderEntry>> byModule = AbstractDependencyDataService.groupByModule((Collection)toRemoveComputable.compute());
        for (Map.Entry<Module, Collection<ExportableOrderEntry>> entry : byModule.entrySet()) {
            this.removeData(entry.getValue(), entry.getKey(), modelsProvider);
        }
    }

    @NotNull
    private static Map<Module, Collection<ExportableOrderEntry>> groupByModule(@NotNull Collection<? extends ExportableOrderEntry> data) {
        HashMap result = ContainerUtilRt.newHashMap();
        for (ExportableOrderEntry exportableOrderEntry : data) {
            Collection entries = (Collection)result.get(exportableOrderEntry.getOwnerModule());
            if (entries == null) {
                entries = ContainerUtilRt.newArrayList();
                result.put(exportableOrderEntry.getOwnerModule(), entries);
            }
            entries.add(exportableOrderEntry);
        }
        return result;
    }

    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove.isEmpty()) {
            return;
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        for (ExportableOrderEntry exportableOrderEntry : toRemove) {
            modifiableRootModel.removeOrderEntry((OrderEntry)exportableOrderEntry);
        }
    }

    private static String getInternalName(AbstractDependencyData data) {
        if (data instanceof LibraryDependencyData) {
            String name = data.getInternalName();
            if (StringUtil.isNotEmpty((String)name)) {
                return name;
            }
            Set paths = ((LibraryData)((LibraryDependencyData)data).getTarget()).getPaths(LibraryPathType.BINARY);
            if (!paths.isEmpty()) {
                String url = (String)paths.iterator().next();
                return PathUtil.toPresentableUrl((String)url);
            }
            return ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
        }
        return data.getInternalName();
    }
}

