/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemAutoImporter
implements BulkFileListener,
DocumentListener {
    @NotNull
    private final ConcurrentMap<ProjectSystemId, Set<String>> myFilesToRefresh = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Alarm myVfsAlarm;
    @NotNull
    private final ReadWriteLock myVfsLock = new ReentrantReadWriteLock();
    @NotNull
    private final Set<Document> myDocumentsToSave = ContainerUtilRt.newHashSet();
    @NotNull
    private final Alarm myDocumentAlarm;
    @NotNull
    private final ReadWriteLock myDocumentLock = new ReentrantReadWriteLock();
    @NotNull
    private final Runnable myFilesRequest = new Runnable(){

        @Override
        public void run() {
            ExternalSystemAutoImporter.this.refreshFilesIfNecessary();
        }
    };
    @NotNull
    private final Runnable myDocumentsSaveRequest = new Runnable(){

        @Override
        public void run() {
            ExternalSystemAutoImporter.this.saveDocumentsIfNecessary();
        }
    };
    @NotNull
    private final ExternalProjectRefreshCallback myRefreshCallback = new ExternalProjectRefreshCallback(){

        @Override
        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject != null) {
                ExternalSystemAutoImporter.this.myProjectDataManager.importData(externalProject, ExternalSystemAutoImporter.this.myProject, true);
            }
        }

        @Override
        public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final MyEntry[] myAutoImportAware;

    public ExternalSystemAutoImporter(@NotNull Project project2, @NotNull ProjectDataManager projectDataManager, @NotNull MyEntry[] autoImportAware) {
        this.myProject = project2;
        this.myProjectDataManager = projectDataManager;
        this.myAutoImportAware = autoImportAware;
        this.myVfsAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project2);
        this.myDocumentAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project2);
    }

    public static void letTheMagicBegin(@NotNull Project project2) {
        ArrayList autoImportAware = ContainerUtilRt.newArrayList();
        Collection managers = ExternalSystemApiUtil.getAllManagers();
        for (ExternalSystemManager manager : managers) {
            AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project2);
            ExternalSystemAutoImportAware defaultImportAware = ExternalSystemAutoImporter.createDefault(systemSettings);
            ExternalSystemAutoImportAware aware = manager instanceof ExternalSystemAutoImportAware ? ExternalSystemAutoImporter.combine(defaultImportAware, (ExternalSystemAutoImportAware)manager) : defaultImportAware;
            autoImportAware.add(new MyEntry(manager.getSystemId(), systemSettings, aware));
        }
        MyEntry[] entries = autoImportAware.toArray(new MyEntry[autoImportAware.size()]);
        ExternalSystemAutoImporter autoImporter = new ExternalSystemAutoImporter(project2, (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class), entries);
        MessageBus messageBus = project2.getMessageBus();
        messageBus.connect((Disposable)project2).subscribe(VirtualFileManager.VFS_CHANGES, (Object)autoImporter);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)autoImporter, (Disposable)project2);
    }

    @NotNull
    private static ExternalSystemAutoImportAware combine(final @NotNull ExternalSystemAutoImportAware aware1, final @NotNull ExternalSystemAutoImportAware aware2) {
        return new ExternalSystemAutoImportAware(){

            @Nullable
            public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project2) {
                String projectPath = aware1.getAffectedExternalProjectPath(changedFileOrDirPath, project2);
                return projectPath == null ? aware2.getAffectedExternalProjectPath(changedFileOrDirPath, project2) : projectPath;
            }
        };
    }

    @NotNull
    private static ExternalSystemAutoImportAware createDefault(final @NotNull AbstractExternalSystemSettings<?, ?, ?> systemSettings) {
        return new ExternalSystemAutoImportAware(){

            @Nullable
            public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project2) {
                return systemSettings.getLinkedProjectSettings(changedFileOrDirPath) == null ? null : changedFileOrDirPath;
            }
        };
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        Document document = event.getDocument();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile file2 = fileDocumentManager.getFile(document);
        if (file2 == null) {
            return;
        }
        String path = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2);
        for (MyEntry entry : this.myAutoImportAware) {
            if (entry.aware.getAffectedExternalProjectPath(path, this.myProject) == null) continue;
            this.scheduleDocumentSave(document);
            return;
        }
    }

    private void scheduleDocumentSave(@NotNull Document document) {
        Lock lock = this.myDocumentLock.readLock();
        lock.lock();
        try {
            this.myDocumentsToSave.add(document);
            if (this.myDocumentAlarm.getActiveRequestCount() <= 0) {
                this.myDocumentAlarm.addRequest(this.myDocumentsSaveRequest, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentsIfNecessary() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Lock lock = this.myDocumentLock.writeLock();
        HashSet toKeep = ContainerUtilRt.newHashSet();
        final HashSet toSave = ContainerUtilRt.newHashSet();
        lock.lock();
        try {
            this.myDocumentAlarm.cancelAllRequests();
            for (Document document : this.myDocumentsToSave) {
                if (fileDocumentManager.isDocumentUnsaved(document)) {
                    toSave.add(document);
                    continue;
                }
                toKeep.add(document);
            }
            this.myDocumentsToSave.clear();
            if (!toSave.isEmpty()) {
                ExternalSystemAutoImporter.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        for (Document document : toSave) {
                            fileDocumentManager.saveDocument(document);
                        }
                    }
                });
            }
            if (!toKeep.isEmpty()) {
                this.myDocumentsToSave.addAll(toKeep);
                this.myDocumentAlarm.addRequest(this.myDocumentsSaveRequest, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void invokeLaterIfNeeded(Runnable runnable2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        boolean scheduleRefresh = false;
        block0: for (VFileEvent vFileEvent : events) {
            String changedPath = vFileEvent.getPath();
            for (MyEntry entry : this.myAutoImportAware) {
                ExternalProjectSettings projectSettings;
                String projectPath = entry.aware.getAffectedExternalProjectPath(changedPath, this.myProject);
                if (projectPath == null || (projectSettings = entry.systemSettings.getLinkedProjectSettings(projectPath)) == null || !projectSettings.isUseAutoImport()) continue;
                this.addPath(entry.externalSystemId, projectPath);
                scheduleRefresh = true;
                continue block0;
            }
        }
        if (scheduleRefresh) {
            this.myVfsAlarm.cancelAllRequests();
            this.myVfsAlarm.addRequest(this.myFilesRequest, ExternalSystemConstants.AUTO_IMPORT_DELAY_MILLIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(@NotNull ProjectSystemId externalSystemId, @NotNull String path) {
        Lock lock = this.myVfsLock.readLock();
        lock.lock();
        try {
            Set paths = (Set)this.myFilesToRefresh.get(externalSystemId);
            while (paths == null) {
                this.myFilesToRefresh.putIfAbsent(externalSystemId, ContainerUtilRt.newHashSet());
                paths = (Set)this.myFilesToRefresh.get(externalSystemId);
            }
            paths.add(path);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFilesIfNecessary() {
        if (this.myFilesToRefresh.isEmpty() || this.myProject.isDisposed()) {
            return;
        }
        HashMap copy = ContainerUtilRt.newHashMap();
        Lock fileLock = this.myVfsLock.writeLock();
        fileLock.lock();
        try {
            copy.putAll(this.myFilesToRefresh);
            this.myFilesToRefresh.clear();
        }
        finally {
            fileLock.unlock();
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Lock documentLock = this.myDocumentLock.writeLock();
        documentLock.lock();
        try {
            for (Set paths : copy.values()) {
                for (String string : paths) {
                    Document document;
                    VirtualFile file2 = fileSystem.findFileByPath(string);
                    if (file2 == null || (document = fileDocumentManager.getCachedDocument(file2)) == null) continue;
                    this.myDocumentsToSave.remove(document);
                }
            }
        }
        finally {
            documentLock.unlock();
        }
        boolean scheduleRefresh = false;
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        for (Map.Entry entry : copy.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                ExternalSystemTaskState taskState;
                ExternalSystemTask resolveTask = processingManager.findTask(ExternalSystemTaskType.RESOLVE_PROJECT, (ProjectSystemId)entry.getKey(), path);
                ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
                if (taskState == null || taskState.isStopped()) {
                    ExternalSystemUtil.refreshProject(this.myProject, (ProjectSystemId)entry.getKey(), path, this.myRefreshCallback, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
                    continue;
                }
                if (taskState == ExternalSystemTaskState.NOT_STARTED) continue;
                scheduleRefresh = true;
                this.addPath((ProjectSystemId)entry.getKey(), path);
            }
        }
        if (scheduleRefresh) {
            this.myVfsAlarm.cancelAllRequests();
            this.myVfsAlarm.addRequest(this.myFilesRequest, ExternalSystemConstants.AUTO_IMPORT_DELAY_MILLIS);
        }
    }

    private static class MyEntry {
        @NotNull
        public final ProjectSystemId externalSystemId;
        @NotNull
        public final AbstractExternalSystemSettings<?, ?, ?> systemSettings;
        @NotNull
        public final ExternalSystemAutoImportAware aware;

        MyEntry(@NotNull ProjectSystemId externalSystemId, @NotNull AbstractExternalSystemSettings<?, ?, ?> systemSettings, @NotNull ExternalSystemAutoImportAware aware) {
            this.externalSystemId = externalSystemId;
            this.systemSettings = systemSettings;
            this.aware = aware;
        }
    }
}

