/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingExternalSystemAutoImportAware
implements ExternalSystemAutoImportAware {
    @NotNull
    private final ConcurrentMap<String, String> myCache = ContainerUtil.newConcurrentMap();
    @NotNull
    private final ExternalSystemAutoImportAware myDelegate;

    public CachingExternalSystemAutoImportAware(@NotNull ExternalSystemAutoImportAware delegate) {
        this.myDelegate = delegate;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project2) {
        String cached = (String)this.myCache.get(changedFileOrDirPath);
        if (cached != null) {
            return cached;
        }
        String result = this.myDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project2);
        if (result != null) {
            this.myCache.put(changedFileOrDirPath, result);
        }
        return result;
    }
}

