/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Computable;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import org.jetbrains.annotations.NotNull;

public class IdeModifiableModelsProviderImpl
extends AbstractIdeModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public IdeModifiableModelsProviderImpl(Project project2) {
        super(project2);
        this.myLibrariesModel = ProjectLibraryTable.getInstance(this.myProject).getModifiableModel();
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        return this.myLibrariesModel;
    }

    @Override
    protected ModifiableArtifactModel doGetModifiableArtifactModel() {
        return (ModifiableArtifactModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableArtifactModel>(){

            public ModifiableArtifactModel compute() {
                return ArtifactManager.getInstance((Project)IdeModifiableModelsProviderImpl.this.myProject).createModifiableModel();
            }
        });
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return (ModifiableModuleModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableModuleModel>(){

            public ModifiableModuleModel compute() {
                return ModuleManager.getInstance((Project)IdeModifiableModelsProviderImpl.this.myProject).getModifiableModel();
            }
        });
    }

    @Override
    @NotNull
    protected ModifiableRootModel doGetModifiableRootModel(final @NotNull Module module2) {
        return (ModifiableRootModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableRootModel>(){

            public ModifiableRootModel compute() {
                return ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            }
        });
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module2) {
        return FacetManager.getInstance((Module)module2).createModifiableModel();
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return library.getModifiableModel();
    }
}

