/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private Map<Module, ModifiableRootModel> myModifiableRootModels = new THashMap();
    private Map<Module, ModifiableFacetModel> myModifiableFacetModels = new THashMap();
    private Map<Module, String> myProductionModulesForTestModules = new THashMap();
    private Map<Library, Library.ModifiableModel> myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();

    public AbstractIdeModifiableModelsProvider(@NotNull Project project2) {
        super(project2);
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @NotNull
    public Module[] getModules() {
        return this.getModifiableModuleModel().getModules();
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        return this.getRootModel(module2).getOrderEntries();
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        Module module2 = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtil.getNameWithoutExtension((File)new File(filePath));
        if (!module2.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module2, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module2.setOption("type", moduleTypeId);
        return module2;
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module2 = this.getModifiableModuleModel().findModuleByName(ideModuleName);
        return module2 == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module2;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        return this.getRootModel(module2).getContentRoots();
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        return this.getRootModel(module2).getSourceRoots();
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        return this.getRootModel(module2).getSourceRoots(includingTests);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        return this.myModifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module2) {
        return (ModifiableRootModel)this.getRootModel(module2);
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module2) {
        ModifiableRootModel result = this.myModifiableRootModels.get(module2);
        if (result == null) {
            result = this.doGetModifiableRootModel(module2);
            this.myModifiableRootModels.put(module2, result);
        }
        return result;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module2) {
        ModifiableFacetModel result = this.myModifiableFacetModels.get(module2);
        if (result == null) {
            result = this.doGetModifiableFacetModel(module2);
            this.myModifiableFacetModels.put(module2, result);
        }
        return result;
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        return this.myModifiableArtifactModel;
    }

    @NotNull
    public Library[] getAllLibraries() {
        return this.getModifiableProjectLibrariesModel().getLibraries();
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        Library.ModifiableModel result = this.myModifiableLibraryModels.get(library);
        if (result == null) {
            result = this.doGetModifiableLibraryModel(library);
            this.myModifiableLibraryModels.put(library, result);
        }
        return result;
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model = this.myModifiableLibraryModels.get(library);
        if (model != null) {
            return model.getUrls(type);
        }
        return library.getUrls(type);
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph(true);
        Iterator i = graph.getOut((Object)module2);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        return list;
    }

    private Graph<Module> getModuleGraph(final boolean includeTests) {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return ContainerUtil.list((Object[])AbstractIdeModifiableModelsProvider.this.getModules());
            }

            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(includeTests);
                return Arrays.asList(dependentModules).iterator();
            }
        }));
    }

    public void commit() {
        ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myProject)).mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                AbstractIdeModifiableModelsProvider.this.processExternalArtifactDependencies();
                for (Library.ModifiableModel each : AbstractIdeModifiableModelsProvider.this.myModifiableLibraryModels.values()) {
                    each.commit();
                }
                AbstractIdeModifiableModelsProvider.this.getModifiableProjectLibrariesModel().commit();
                Collection rootModels = AbstractIdeModifiableModelsProvider.this.myModifiableRootModels.values();
                ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
                for (ModifiableRootModel model : rootModels1) {
                    assert (!model.isDisposed()) : "Already disposed: " + model;
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel != null) {
                    ModifiableModelCommitter.multiCommit(rootModels1, AbstractIdeModifiableModelsProvider.this.myModifiableModuleModel);
                } else {
                    for (ModifiableRootModel model : rootModels1) {
                        model.commit();
                    }
                }
                for (Map.Entry entry : AbstractIdeModifiableModelsProvider.this.myProductionModulesForTestModules.entrySet()) {
                    TestModuleProperties.getInstance((Module)entry.getKey()).setProductionModuleName((String)entry.getValue());
                }
                for (Map.Entry entry : AbstractIdeModifiableModelsProvider.this.myModifiableFacetModels.entrySet()) {
                    if (((Module)entry.getKey()).isDisposed()) continue;
                    ((ModifiableFacetModel)entry.getValue()).commit();
                }
                if (AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel != null) {
                    AbstractIdeModifiableModelsProvider.this.myModifiableArtifactModel.commit();
                }
            }
        });
    }

    public void dispose() {
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module2) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getAllFacets();
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module2, FacetTypeId<F> type) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getFacetsByType(type);
        }

        public <F extends Facet> F findFacet(Module module2, FacetTypeId<F> type, String name) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).findFacet(type, name);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            return AbstractIdeModifiableModelsProvider.this.getModules();
        }

        public Module getModule(String name) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module2) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module2);
        }

        public FacetModel getFacetModel(@NotNull Module module2) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider(this);
        }

        @NotNull
        public Project getProject() {
            return AbstractIdeModifiableModelsProvider.this.myProject;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            return AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            return this.myModulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            return this.myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            return this.myManifestFileProvider;
        }
    }
}

