/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecuteTaskTask
extends AbstractExternalSystemTask {
    @NotNull
    private static final Function<ExternalTaskPojo, String> MAPPER = new Function<ExternalTaskPojo, String>(){

        public String fun(ExternalTaskPojo task) {
            return task.getName();
        }
    };
    @NotNull
    private final List<ExternalTaskPojo> myTasksToExecute;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private String myScriptParameters;
    @Nullable
    private final String myDebuggerSetup;

    public ExternalSystemExecuteTaskTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull List<ExternalTaskPojo> tasksToExecute, @Nullable String vmOptions, @Nullable String scriptParameters, @Nullable String debuggerSetup) throws IllegalArgumentException {
        super(externalSystemId, ExternalSystemTaskType.EXECUTE_TASK, project2, ExternalSystemExecuteTaskTask.getLinkedExternalProjectPath(tasksToExecute));
        this.myTasksToExecute = tasksToExecute;
        this.myVmOptions = vmOptions;
        this.myScriptParameters = scriptParameters;
        this.myDebuggerSetup = debuggerSetup;
    }

    @NotNull
    public List<ExternalTaskPojo> getTasksToExecute() {
        return this.myTasksToExecute;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    public void appendScriptParameters(@NotNull String scriptParameters) {
        this.myScriptParameters = this.myScriptParameters == null ? scriptParameters : this.myScriptParameters + ' ' + scriptParameters;
    }

    @NotNull
    private static String getLinkedExternalProjectPath(@NotNull Collection<ExternalTaskPojo> tasks) throws IllegalArgumentException {
        if (tasks.isEmpty()) {
            throw new IllegalArgumentException("Can't execute external tasks. Reason: given tasks list is empty");
        }
        String result = null;
        for (ExternalTaskPojo task : tasks) {
            String path = task.getLinkedExternalProjectPath();
            if (result == null) {
                result = path;
                continue;
            }
            if (result.equals(path)) continue;
            throw new IllegalArgumentException(String.format("Can't execute given external system tasks. Reason: expected that all of them belong to the same external project but they are not (at least two different projects detected - '%s' and '%s'). Tasks: %s", result, task.getLinkedExternalProjectPath(), tasks));
        }
        assert (result != null);
        return result;
    }

    @Override
    protected void doExecute() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)this.getIdeProject(), (String)this.getExternalProjectPath(), (ProjectSystemId)this.getExternalSystemId());
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager<ExternalSystemExecutionSettings> taskManager = facade.getTaskManager();
        List taskNames = ContainerUtilRt.map2List(this.myTasksToExecute, MAPPER);
        List<String> vmOptions = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myVmOptions);
        List<String> scriptParametersList = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myScriptParameters);
        taskManager.executeTasks(this.getId(), taskNames, this.getExternalProjectPath(), settings, vmOptions, scriptParametersList, this.myDebuggerSetup);
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager taskManager = facade.getTaskManager();
        return taskManager.cancelTask(this.getId());
    }

    private static List<String> parseCmdParameters(@Nullable String cmdArgsLine) {
        return cmdArgsLine != null ? ParametersListUtil.parse((String)cmdArgsLine) : ContainerUtil.newArrayList();
    }
}

