/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
implements ExternalSystemTask {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractExternalSystemTask.class.getName()));
    private final AtomicReference<ExternalSystemTaskState> myState = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
    private final AtomicReference<Throwable> myError = new AtomicReference();
    @NotNull
    private final transient Project myIdeProject;
    @NotNull
    private final ExternalSystemTaskId myId;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectPath;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id, @NotNull ExternalSystemTaskType type, @NotNull Project project2, @NotNull String externalProjectPath) {
        this.myExternalSystemId = id;
        this.myIdeProject = project2;
        this.myId = ExternalSystemTaskId.create((ProjectSystemId)id, (ExternalSystemTaskType)type, (Project)this.myIdeProject);
        this.myExternalProjectPath = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        return this.myId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        return this.myState.get();
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        this.myState.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update) {
        return this.myState.compareAndSet(expect, update);
    }

    public Throwable getError() {
        return this.myError.get();
    }

    @NotNull
    public Project getIdeProject() {
        return this.myIdeProject;
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade facade = manager.getFacade(this.myIdeProject, this.myExternalProjectPath, this.myExternalSystemId);
                this.setState(facade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable e) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.myError.set(e);
                if (this.myIdeProject.isDisposed()) break block3;
                LOG.warn(e);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter) : new ExternalSystemTaskNotificationListener[]{adapter};
        this.execute(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        try {
            processingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        finally {
            for (ExternalSystemTaskNotificationListener listener3 : listeners) {
                progressManager.removeNotificationListener(listener3);
            }
            processingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter) : new ExternalSystemTaskNotificationListener[]{adapter};
        return this.cancel(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState currentTaskState = this.getState();
        if (currentTaskState.isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        if (!this.compareAndSetState(currentTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        int result = 0;
        try {
            result = this.doCancel();
            this.setState(result != 0 ? ExternalSystemTaskState.CANCELED : ExternalSystemTaskState.CANCELLATION_FAILED);
            int n = result;
            return n != 0;
        }
        catch (NotSupportedException e) {
            NotificationData notification = new NotificationData("Cancellation failed", e.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notification.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notification);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        finally {
            for (ExternalSystemTaskNotificationListener listener3 : listeners) {
                progressManager.removeNotificationListener(listener3);
            }
        }
        return result != 0;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        return ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), text});
    }

    public int hashCode() {
        return this.myId.hashCode() + this.myExternalSystemId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalSystemTask task = (AbstractExternalSystemTask)o;
        return this.myId.equals((Object)task.myId) && this.myExternalSystemId.equals((Object)task.myExternalSystemId);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.myExternalSystemId.getReadableName(), this.myId, this.myState);
    }
}

