/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution.cmd;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.util.TextFieldCompletionProvider;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import org.jetbrains.annotations.NotNull;

public abstract class CommandLineCompletionProvider
extends TextFieldCompletionProvider {
    private final Options myOptions;

    public CommandLineCompletionProvider(Options options) {
        super(true);
        this.myOptions = options;
    }

    @Override
    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
        while (lexer.nextToken()) {
            if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
            return lexer.getCurrentToken();
        }
        return "";
    }

    protected LookupElement createLookupElement(@NotNull Option option, @NotNull String text) {
        LookupElementBuilder res = LookupElementBuilder.create((String)text);
        if (option.getDescription() != null) {
            return TailTypeDecorator.withTail(res.withTypeText(option.getDescription(), true), TailType.INSERT_SPACE);
        }
        return res;
    }

    protected abstract void addArgumentVariants(@NotNull CompletionResultSet var1);

    @Override
    protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
        ParametersListLexer lexer = new ParametersListLexer(text);
        int argCount = 0;
        while (lexer.nextToken() && offset >= lexer.getTokenStart()) {
            Option option2;
            if (offset <= lexer.getTokenEnd()) {
                if (argCount == 0) {
                    if (prefix.startsWith("--")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getLongOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "--" + option2.getLongOpt()));
                        }
                    } else if (prefix.startsWith("-")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "-" + option2.getOpt()));
                        }
                    } else {
                        this.addArgumentVariants(result);
                    }
                }
                return;
            }
            if (argCount > 0) {
                --argCount;
                continue;
            }
            String token = lexer.getCurrentToken();
            if (!token.startsWith("-") || (option2 = this.myOptions.getOption(token)) == null) continue;
            int optionArgCount = option2.getArgs();
            if (optionArgCount == -2) {
                argCount = Integer.MAX_VALUE;
                continue;
            }
            if (optionArgCount == -1) continue;
            argCount = optionArgCount;
        }
        if (argCount > 0) {
            return;
        }
        this.addArgumentVariants(result);
    }
}

