/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskLocation
extends PsiLocation<PsiElement> {
    @NotNull
    private final ExternalTaskExecutionInfo myTaskInfo;

    public ExternalSystemTaskLocation(@NotNull Project project2, @NotNull PsiElement psiElement, @NotNull ExternalTaskExecutionInfo taskInfo) {
        super(project2, psiElement);
        this.myTaskInfo = taskInfo;
    }

    @NotNull
    public ExternalTaskExecutionInfo getTaskInfo() {
        return this.myTaskInfo;
    }

    public static ExternalSystemTaskLocation create(@NotNull Project project2, @NotNull ProjectSystemId systemId, @Nullable String projectPath, @NotNull ExternalTaskExecutionInfo taskInfo) {
        PsiDirectory psiFile;
        VirtualFile file2;
        if (projectPath != null && (file2 = VfsUtil.findFileByIoFile((File)new File(projectPath), (boolean)false)) != null && (psiFile = PsiManager.getInstance((Project)project2).findDirectory(file2)) != null) {
            return new ExternalSystemTaskLocation(project2, (PsiElement)psiFile, taskInfo);
        }
        String name = systemId.getReadableName() + projectPath + StringUtil.join((Collection)taskInfo.getSettings().getTaskNames(), (String)" ");
        psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText(name, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"");
        return new ExternalSystemTaskLocation(project2, (PsiElement)psiFile, taskInfo);
    }
}

