/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.internal;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalExternalProjectInfo
implements ExternalProjectInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    @NotNull
    private final String myExternalProjectPath;
    @Nullable
    private DataNode<ProjectData> myExternalProjectStructure;
    private long lastSuccessfulImportTimestamp = -1L;
    private long lastImportTimestamp = -1L;

    public InternalExternalProjectInfo(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath, @Nullable DataNode<ProjectData> externalProjectStructure) {
        this.myProjectSystemId = projectSystemId;
        this.myExternalProjectPath = externalProjectPath;
        this.myExternalProjectStructure = externalProjectStructure;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.myExternalProjectPath;
    }

    @Nullable
    public DataNode<ProjectData> getExternalProjectStructure() {
        return this.myExternalProjectStructure;
    }

    public long getLastSuccessfulImportTimestamp() {
        return this.lastSuccessfulImportTimestamp;
    }

    public long getLastImportTimestamp() {
        return this.lastImportTimestamp;
    }

    public void setExternalProjectStructure(@Nullable DataNode<ProjectData> externalProjectStructure) {
        this.myExternalProjectStructure = externalProjectStructure;
    }

    public void setLastSuccessfulImportTimestamp(long lastSuccessfulImportTimestamp) {
        this.lastSuccessfulImportTimestamp = lastSuccessfulImportTimestamp;
    }

    public void setLastImportTimestamp(long lastImportTimestamp) {
        this.lastImportTimestamp = lastImportTimestamp;
    }

    public ExternalProjectInfo copy() {
        InternalExternalProjectInfo copy = new InternalExternalProjectInfo(this.myProjectSystemId, this.myExternalProjectPath, this.myExternalProjectStructure != null ? this.myExternalProjectStructure.graphCopy() : null);
        copy.setLastImportTimestamp(this.lastImportTimestamp);
        copy.setLastSuccessfulImportTimestamp(this.lastSuccessfulImportTimestamp);
        return copy;
    }

    public String toString() {
        return "InternalExternalProjectInfo{myProjectSystemId=" + this.myProjectSystemId + ", myExternalProjectPath='" + this.myExternalProjectPath + '\'' + ", myExternalProjectStructure=" + this.myExternalProjectStructure + ", lastSuccessfulImportTimestamp=" + this.lastSuccessfulImportTimestamp + ", lastImportTimestamp=" + this.lastImportTimestamp + '}';
    }
}

