/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;

public class ToggleAutoImportAction
extends ExternalSystemToggleAction {
    public ToggleAutoImportAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.auto.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.auto.description", (Object[])new Object[0]));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        if (this.getSystemId(e) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    @Override
    protected boolean isVisible(AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        if (this.getSystemId(e) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        ExternalProjectSettings projectSettings = this.getProjectSettings(e);
        return projectSettings != null && projectSettings.isUseAutoImport();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ExternalProjectSettings projectSettings = this.getProjectSettings(e);
        if (projectSettings != null && state != projectSettings.isUseAutoImport()) {
            projectSettings.setUseAutoImport(state);
            ExternalSystemApiUtil.getSettings((Project)this.getProject(e), (ProjectSystemId)this.getSystemId(e)).getPublisher().onUseAutoImportChange(state, projectSettings.getExternalProjectPath());
        }
    }

    @Nullable
    private ExternalProjectSettings getProjectSettings(AnActionEvent e) {
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext());
        if (projectNode == null || projectNode.getData() == null) {
            return null;
        }
        AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getProject(e), (ProjectSystemId)this.getSystemId(e));
        return externalSystemSettings.getLinkedProjectSettings(((ProjectData)projectNode.getData()).getLinkedExternalProjectPath());
    }
}

