/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DetachExternalProjectAction
extends ExternalSystemNodeAction<ProjectData> {
    public DetachExternalProjectAction() {
        super(ProjectData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Remove : AllIcons.ToolbarDecorator.Remove);
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull ProjectData projectData, @NotNull AnActionEvent e) {
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext());
        assert (projectNode != null);
        ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectSystemId).forgetExternalProjects(Collections.singleton(projectData.getLinkedExternalProjectPath()));
        ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).unlinkExternalProject(projectData.getLinkedExternalProjectPath());
        ExternalProjectsManager.getInstance(project2).forgetExternalProjectData(projectSystemId, projectData.getLinkedExternalProjectPath());
        ArrayList orphanModules = ContainerUtilRt.newArrayList();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectSystemId, (Module)module2)) continue;
            String path = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
            if (!projectData.getLinkedExternalProjectPath().equals(path)) continue;
            orphanModules.add(module2);
        }
        if (!orphanModules.isEmpty()) {
            projectNode.getGroup().remove(projectNode);
            ProjectDataManager.getInstance().removeData(ProjectKeys.MODULE, orphanModules, Collections.emptyList(), projectData, project2, false);
        }
    }
}

