/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentCaret;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentCaretModel
implements CaretModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;
    private final Caret myCaret;

    public TextComponentCaretModel(@NotNull JTextComponent textComponent, @NotNull TextComponentEditor editor) {
        this.myTextComponent = textComponent;
        this.myEditor = editor;
        this.myCaret = new TextComponentCaret(editor);
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.myTextComponent.setCaretPosition(Math.min(offset, this.myTextComponent.getText().length()));
    }

    public boolean isUpToDate() {
        return true;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        int caretPos = this.myTextComponent.getCaretPosition();
        if (this.myTextComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this.myTextComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        return new LogicalPosition(line, caretPos - lineStart);
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        return new VisualPosition(pos.line, pos.column);
    }

    public int getOffset() {
        return this.myTextComponent.getCaretPosition();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    @NotNull
    public Caret getCurrentCaret() {
        return this.myCaret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        return this.myCaret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        return Collections.singletonList(this.myCaret);
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        return this.myCaret.getVisualPosition().equals((Object)pos) ? this.myCaret : null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        return null;
    }

    public boolean removeCaret(@NotNull Caret caret) {
        return false;
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        action.perform(this.myCaret);
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        action.perform(this.myCaret);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        runnable2.run();
    }
}

