/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentCaret
extends UserDataHolderBase
implements Caret {
    private final Editor myEditor;

    public TextComponentCaret(Editor editor) {
        this.myEditor = editor;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    public boolean isValid() {
        return true;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.getCaretModel().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.getCaretModel().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCaretModel().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCaretModel().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCaretModel().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        return this.getCaretModel().getLogicalPosition();
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.getCaretModel().getVisualPosition();
    }

    public int getOffset() {
        return this.getCaretModel().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCaretModel().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCaretModel().getVisualLineEnd();
    }

    public int getSelectionStart() {
        return this.getSelectionModel().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        return this.myEditor.offsetToVisualPosition(this.getSelectionModel().getSelectionStart());
    }

    public int getSelectionEnd() {
        return this.getSelectionModel().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        return this.myEditor.offsetToVisualPosition(this.getSelectionModel().getSelectionEnd());
    }

    @Nullable
    public String getSelectedText() {
        return this.getSelectionModel().getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.getSelectionModel().getLeadSelectionOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        return this.myEditor.offsetToVisualPosition(this.getSelectionModel().getLeadSelectionOffset());
    }

    public boolean hasSelection() {
        return this.getSelectionModel().hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        this.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getSelectionModel().setSelection(startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.getSelectionModel().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void removeSelection() {
        this.getSelectionModel().removeSelection();
    }

    public void selectLineAtCaret() {
        this.getSelectionModel().selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.getSelectionModel().selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        return null;
    }

    public void dispose() {
    }

    public boolean isAtRtlLocation() {
        return false;
    }

    public boolean isAtBidiRunBoundary() {
        return false;
    }

    private SelectionModel getSelectionModel() {
        return this.myEditor.getSelectionModel();
    }
}

