/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.AbstractSyntaxAwareReaderTransferableData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;

public class HtmlTransferableData
extends AbstractSyntaxAwareReaderTransferableData
implements MarkupHandler {
    @NotNull
    public static final DataFlavor FLAVOR = new DataFlavor("text/html; class=java.io.Reader; charset=UTF-8", "HTML text");
    private final int myTabSize;
    private StringBuilder myResultBuffer;
    private ColorRegistry myColorRegistry;
    private FontNameRegistry myFontNameRegistry;
    private int myMaxLength;
    private int myDefaultForeground;
    private int myDefaultBackground;
    private int myDefaultFontFamily;
    private int myForeground;
    private int myBackground;
    private int myFontFamily;
    private boolean myBold;
    private boolean myItalic;
    private int myCurrentColumn;
    private final TIntObjectHashMap<String> myColors = new TIntObjectHashMap();

    public HtmlTransferableData(@NotNull SyntaxInfo syntaxInfo, int tabSize) {
        super(syntaxInfo, FLAVOR);
        this.myTabSize = tabSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void build(@NotNull StringBuilder holder, int maxLength) {
        this.myResultBuffer = holder;
        this.myColorRegistry = this.mySyntaxInfo.getColorRegistry();
        this.myFontNameRegistry = this.mySyntaxInfo.getFontNameRegistry();
        this.myDefaultForeground = this.myForeground = this.mySyntaxInfo.getDefaultForeground();
        this.myDefaultBackground = this.myBackground = this.mySyntaxInfo.getDefaultBackground();
        this.myItalic = false;
        this.myBold = false;
        this.myCurrentColumn = 0;
        this.myMaxLength = maxLength;
        try {
            this.buildColorMap();
            this.myResultBuffer.append("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body>").append("<pre style=\"background-color:");
            this.appendColor(this.myResultBuffer, this.myDefaultBackground);
            this.myResultBuffer.append(";color:");
            this.appendColor(this.myResultBuffer, this.myDefaultForeground);
            this.myResultBuffer.append(';');
            int[] fontIds = this.myFontNameRegistry.getAllIds();
            if (fontIds.length > 0) {
                this.myFontFamily = this.myDefaultFontFamily = fontIds[0];
                this.appendFontFamilyRule(this.myResultBuffer, this.myDefaultFontFamily);
            } else {
                this.myDefaultFontFamily = -1;
                this.myFontFamily = -1;
            }
            float fontSize = this.mySyntaxInfo.getFontSize();
            if (SystemInfo.isMac) {
                fontSize *= 0.75f;
            }
            this.myResultBuffer.append(String.format("font-size:%.1fpt;\">", Float.valueOf(fontSize)));
            this.mySyntaxInfo.processOutputInfo(this);
            this.myResultBuffer.append("</pre></body></html>");
        }
        finally {
            this.myResultBuffer = null;
            this.myColorRegistry = null;
            this.myFontNameRegistry = null;
            this.myColors.clear();
        }
    }

    private void appendFontFamilyRule(@NotNull StringBuilder styleBuffer, int fontFamilyId) {
        styleBuffer.append("font-family:'").append((String)this.myFontNameRegistry.dataById(fontFamilyId)).append("';");
    }

    private static void defineBold(@NotNull StringBuilder styleBuffer) {
        styleBuffer.append("font-weight:bold;");
    }

    private static void defineItalic(@NotNull StringBuilder styleBuffer) {
        styleBuffer.append("font-style:italic;");
    }

    private void defineForeground(int id, @NotNull StringBuilder styleBuffer) {
        styleBuffer.append("color:");
        this.appendColor(styleBuffer, id);
        styleBuffer.append(";");
    }

    private void defineBackground(int id, @NotNull StringBuilder styleBuffer) {
        styleBuffer.append("background-color:");
        this.appendColor(styleBuffer, id);
        styleBuffer.append(";");
    }

    private void appendColor(StringBuilder builder, int id) {
        builder.append((String)this.myColors.get(id));
    }

    private void buildColorMap() {
        for (int id : this.myColorRegistry.getAllIds()) {
            StringBuilder b = new StringBuilder("#");
            UIUtil.appendColor((Color)((Color)this.myColorRegistry.dataById(id)), (StringBuilder)b);
            this.myColors.put(id, (Object)b.toString());
        }
    }

    @Override
    public void handleText(int startOffset, int endOffset) {
        boolean formattedText;
        boolean bl = formattedText = this.myForeground != this.myDefaultForeground || this.myBackground != this.myDefaultBackground || this.myFontFamily != this.myDefaultFontFamily || this.myBold || this.myItalic;
        if (!formattedText) {
            this.escapeAndAdd(startOffset, endOffset);
            return;
        }
        this.myResultBuffer.append("<span style=\"");
        if (this.myForeground != this.myDefaultForeground) {
            this.defineForeground(this.myForeground, this.myResultBuffer);
        }
        if (this.myBackground != this.myDefaultBackground) {
            this.defineBackground(this.myBackground, this.myResultBuffer);
        }
        if (this.myBold) {
            HtmlTransferableData.defineBold(this.myResultBuffer);
        }
        if (this.myItalic) {
            HtmlTransferableData.defineItalic(this.myResultBuffer);
        }
        if (this.myFontFamily != this.myDefaultFontFamily) {
            this.appendFontFamilyRule(this.myResultBuffer, this.myFontFamily);
        }
        this.myResultBuffer.append("\">");
        this.escapeAndAdd(startOffset, endOffset);
        this.myResultBuffer.append("</span>");
    }

    private void escapeAndAdd(int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = this.myRawText.charAt(i);
            switch (c) {
                case '<': {
                    this.myResultBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    this.myResultBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    this.myResultBuffer.append("&amp;");
                    break;
                }
                case ' ': {
                    this.myResultBuffer.append("&#32;");
                    break;
                }
                case '\n': {
                    this.myResultBuffer.append("<br>");
                    this.myCurrentColumn = 0;
                    break;
                }
                case '\t': {
                    int newColumn = (this.myCurrentColumn / this.myTabSize + 1) * this.myTabSize;
                    while (this.myCurrentColumn < newColumn) {
                        this.myResultBuffer.append("&#32;");
                        ++this.myCurrentColumn;
                    }
                    break;
                }
                default: {
                    this.myResultBuffer.append(c);
                }
            }
            ++this.myCurrentColumn;
        }
    }

    @Override
    public void handleForeground(int foregroundId) throws Exception {
        this.myForeground = foregroundId;
    }

    @Override
    public void handleBackground(int backgroundId) throws Exception {
        this.myBackground = backgroundId;
    }

    @Override
    public void handleFont(int fontNameId) throws Exception {
        this.myFontFamily = fontNameId;
    }

    @Override
    public void handleStyle(int style) throws Exception {
        this.myBold = (1 & style) != 0;
        this.myItalic = (2 & style) != 0;
    }

    @Override
    public boolean canHandleMore() {
        if (this.myResultBuffer.length() > this.myMaxLength) {
            this.myResultBuffer.append("... truncated ...");
            return false;
        }
        return true;
    }
}

