/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRegistry<T> {
    @NotNull
    private final TIntObjectHashMap<T> myDataById = new TIntObjectHashMap();
    private transient TObjectIntHashMap<T> myIdsByData = new TObjectIntHashMap();

    @NotNull
    public T dataById(int id) throws IllegalArgumentException {
        Object result = this.myDataById.get(id);
        if (result == null) {
            throw new IllegalArgumentException("No data is registered for id " + id);
        }
        return (T)result;
    }

    public int getId(@NotNull T data) throws IllegalStateException {
        if (this.myIdsByData == null) {
            throw new IllegalStateException(String.format("Can't register data '%s'. Reason: the %s registry is already sealed", data, this.getClass().getName()));
        }
        int id = this.myIdsByData.get(data);
        if (id <= 0) {
            id = this.myIdsByData.size() + 1;
            this.myDataById.put(id, data);
            this.myIdsByData.put(data, id);
        }
        return id;
    }

    public int[] getAllIds() {
        int[] result = this.myDataById.keys();
        Arrays.sort(result);
        return result;
    }

    public int size() {
        return this.myDataById.size();
    }

    public void seal() {
        this.myIdsByData = null;
        this.myDataById.compact();
    }
}

