/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.SimpleTextFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

class TextFragmentFactory {
    TextFragmentFactory() {
    }

    public static TextFragment createTextFragment(@NotNull char[] lineChars, int start, int end, boolean isRtl, @NotNull FontInfo fontInfo, @NotNull FontRenderContext fontRenderContext) {
        if (isRtl || fontInfo.getFont().hasLayoutAttributes() || TextFragmentFactory.isComplexText(lineChars, start, end)) {
            return new ComplexTextFragment(lineChars, start, end, isRtl, fontInfo.getFont(), fontRenderContext);
        }
        return new SimpleTextFragment(lineChars, start, end, fontInfo);
    }

    private static boolean isComplexText(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars[i] < '\u0300') continue;
            return true;
        }
        return false;
    }
}

