/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FontLayoutService {
    private static final FontLayoutService DEFAULT_INSTANCE;
    private static FontLayoutService INSTANCE;

    public static FontLayoutService getInstance() {
        return INSTANCE;
    }

    @NotNull
    public abstract GlyphVector layoutGlyphVector(@NotNull Font var1, @NotNull FontRenderContext var2, @NotNull char[] var3, int var4, int var5, boolean var6);

    public abstract int charWidth(@NotNull FontMetrics var1, char var2);

    public abstract int getHeight(@NotNull FontMetrics var1);

    public abstract int getAscent(@NotNull FontMetrics var1);

    public static void setInstance(@Nullable FontLayoutService fontLayoutService) {
        INSTANCE = fontLayoutService == null ? DEFAULT_INSTANCE : fontLayoutService;
    }

    static {
        INSTANCE = DEFAULT_INSTANCE = new DefaultFontLayoutService();
    }

    private static class DefaultFontLayoutService
    extends FontLayoutService {
        private DefaultFontLayoutService() {
        }

        @Override
        @NotNull
        public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl) {
            return font.layoutGlyphVector(fontRenderContext, chars, start, end, isRtl ? 1 : 0);
        }

        @Override
        public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
            return fontMetrics.charWidth(c);
        }

        @Override
        public int getHeight(@NotNull FontMetrics fontMetrics) {
            return fontMetrics.getHeight();
        }

        @Override
        public int getAscent(@NotNull FontMetrics fontMetrics) {
            return fontMetrics.getAscent();
        }
    }
}

