/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.impl.VisualSizeChangeListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SoftWrapAwareVisualSizeManager
extends SoftWrapAwareDocumentParsingListenerAdapter {
    private final List<VisualSizeChangeListener> myListeners = new ArrayList<VisualSizeChangeListener>();
    private final TIntIntHashMap myLineWidths = new TIntIntHashMap();
    private SoftWrapPainter myPainter;
    private int myLastLogicalLine;

    public SoftWrapAwareVisualSizeManager(@NotNull SoftWrapPainter painter) {
        this.myPainter = painter;
    }

    public boolean addVisualSizeChangeListener(@NotNull VisualSizeChangeListener listener2) {
        return this.myListeners.add(listener2);
    }

    @Override
    public void onCacheUpdateStart(@NotNull IncrementalCacheUpdateEvent event) {
        this.myLineWidths.clear();
    }

    @Override
    public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
        if (this.myListeners.isEmpty()) {
            return;
        }
        int startLine = event.getStartLogicalLine();
        int oldEndLine = event.getOldEndLogicalLine();
        for (VisualSizeChangeListener listener2 : this.myListeners) {
            listener2.onLineWidthsChange(startLine, oldEndLine, this.myLastLogicalLine, this.myLineWidths);
        }
    }

    @Override
    public void onVisualLineEnd(@NotNull EditorPosition position) {
        if (this.myListeners.isEmpty()) {
            return;
        }
        this.updateLineWidthIfNecessary(position.logicalLine, position.x);
        this.myLastLogicalLine = position.logicalLine;
    }

    @Override
    public void beforeSoftWrapLineFeed(@NotNull EditorPosition position) {
        int newWidth = position.x + this.myPainter.getMinDrawingWidth(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        this.myLastLogicalLine = position.logicalLine;
        if (!this.myLineWidths.contains(position.logicalLine)) {
            this.myLineWidths.put(position.logicalLine, newWidth);
            return;
        }
        this.updateLineWidthIfNecessary(position.logicalLine, newWidth);
    }

    private void updateLineWidthIfNecessary(int line, int width) {
        int storedWidth = this.myLineWidths.get(line);
        if (width > storedWidth) {
            this.myLineWidths.put(line, width);
        }
    }

    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
    }
}

